/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.httpserver;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import si.nevensrok.common.utils.StringUtil;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.MatchRound;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.Duo2023Points;
import si.nevensrok.jtekma.tabla.common.DuoPoints;
import si.nevensrok.jtekma.tabla.common.DuoPresentationPoints;
import si.nevensrok.jtekma.tabla.common.FightPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.NewazaPoints;
import si.nevensrok.jtekma.tabla.common.TableType;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.httpserver.MatchInfoResponseData;

public class TablaInfoHttpHandler
implements HttpHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TablaInfoHttpHandler.class);
    private MatchData matchData;
    private FightPoints fightPoints;
    private DuoPoints duoPoints;
    private NewazaPoints newazaPoints;
    private Duo2023Points duo2023Points;
    private DuoPresentationPoints duoPresentationPoints;
    private RulesManager rulesManager;
    private ObjectMapper objectMapper = new ObjectMapper();
    private TablaManager tablaManager;

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setFightPoints(FightPoints fightPoints) {
        this.fightPoints = fightPoints;
    }

    public void setDuoPoints(DuoPoints duoPoints) {
        this.duoPoints = duoPoints;
    }

    public void setNewazaPoints(NewazaPoints newazaPoints) {
        this.newazaPoints = newazaPoints;
    }

    public void setDuo2023Points(Duo2023Points duo2023Points) {
        this.duo2023Points = duo2023Points;
    }

    public void setDuoPresentationPoints(DuoPresentationPoints duoPresentationPoints) {
        this.duoPresentationPoints = duoPresentationPoints;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try {
            float points1;
            Set<MatchPoint> matchPoints;
            httpExchange.getResponseHeaders().add("Content-Type", "application/json; charset=utf-8");
            httpExchange.sendResponseHeaders(HttpStatus.OK.value(), 0L);
            OutputStream outputStream = httpExchange.getResponseBody();
            MatchInfoResponseData matchInfoResponseData = new MatchInfoResponseData();
            matchInfoResponseData.setName1(this.matchData.getName1() + " / " + this.matchData.getClub1());
            matchInfoResponseData.setName2(this.matchData.getName2() + " / " + this.matchData.getClub2());
            long time = this.matchData.getTimeLeft() / 1000L;
            long minutes = time / 60L;
            long seconds = time % 60L;
            matchInfoResponseData.setTime(String.valueOf(minutes) + ":" + Constants.SECONDS_NUMBER_FORMAT.format(seconds));
            CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(this.matchData.getRules());
            if (this.matchData.getTableType() == TableType.FIGHT) {
                matchPoints = this.fightPoints.getMatchPoints(competitionRules);
                points1 = competitionRules.sumPointsFor(Match.Type.FIGHT, CompetitorType.COMPETITOR1, matchPoints);
                float points2 = competitionRules.sumPointsFor(Match.Type.FIGHT, CompetitorType.COMPETITOR2, matchPoints);
                matchInfoResponseData.setPoints1(Constants.FIGHT_POINTS_FORMAT.format(points1));
                matchInfoResponseData.setPoints2(Constants.FIGHT_POINTS_FORMAT.format(points2));
            } else if (this.matchData.getTableType() == TableType.DUO) {
                matchInfoResponseData.setTime("");
                matchPoints = this.duoPoints.getMatchPoints();
                points1 = competitionRules.sumPointsFor(Match.Type.DUO, CompetitorType.COMPETITOR1, matchPoints);
                float points2 = competitionRules.sumPointsFor(Match.Type.DUO, CompetitorType.COMPETITOR2, matchPoints);
                matchInfoResponseData.setPoints1(Constants.DUO_POINTS_FORMAT.format(points1));
                matchInfoResponseData.setPoints2(Constants.DUO_POINTS_FORMAT.format(points2));
            } else if (this.matchData.getTableType() == TableType.NEWAZA) {
                matchPoints = this.newazaPoints.getMatchPoints();
                points1 = competitionRules.sumPointsFor(Match.Type.NEWAZA, CompetitorType.COMPETITOR1, matchPoints);
                float points2 = competitionRules.sumPointsFor(Match.Type.NEWAZA, CompetitorType.COMPETITOR2, matchPoints);
                matchInfoResponseData.setPoints1(Constants.FIGHT_POINTS_FORMAT.format(points1));
                matchInfoResponseData.setPoints2(Constants.FIGHT_POINTS_FORMAT.format(points2));
            } else if (this.matchData.getTableType() == TableType.DUO2023) {
                matchInfoResponseData.setTime("");
                matchPoints = this.duo2023Points.getMatchPoints();
                points1 = competitionRules.sumPointsFor(Match.Type.DUO2023, CompetitorType.COMPETITOR1, matchPoints);
                float points2 = competitionRules.sumPointsFor(Match.Type.DUO2023, CompetitorType.COMPETITOR2, matchPoints);
                matchInfoResponseData.setPoints1(Constants.FIGHT_POINTS_FORMAT.format(points1));
                matchInfoResponseData.setPoints2(Constants.FIGHT_POINTS_FORMAT.format(points2));
            } else if (this.matchData.getTableType() == TableType.DUO_PRESENTATION) {
                matchInfoResponseData.setTime("");
                matchPoints = this.duoPresentationPoints.getMatchPoints();
                float points = competitionRules.sumDuoPresentationPoints(matchPoints);
                matchInfoResponseData.setPoints1(Constants.FIGHT_POINTS_FORMAT.format(points));
            }
            StringBuilder category = new StringBuilder();
            category.append(this.matchData.getCategory());
            if (this.matchData.getTableType() == TableType.DUO2023 || this.matchData.getTableType() == TableType.DUO_PRESENTATION) {
                StringBuilder additionalText = new StringBuilder();
                if (this.matchData.getRound() == Round.ROUND_1 || this.matchData.getRound() == Round.ROUND_2 || this.matchData.getRound() == Round.ROUND_3) {
                    additionalText.append(this.tablaManager.getLanguageText("text.round"));
                    additionalText.append(" ");
                    additionalText.append(this.matchData.getRound().ordinal() + 1);
                } else if (this.matchData.getRound() == Round.ROUND_4) {
                    additionalText.append(this.tablaManager.getLanguageText("text.halfFinals"));
                } else if (this.matchData.getRound() == Round.ROUND_5) {
                    additionalText.append(this.tablaManager.getLanguageText("text.finals"));
                }
                if (additionalText.length() > 0) {
                    if (this.matchData.getRank() == Rank.WORLD_LEVEL) {
                        additionalText.append(", ");
                        additionalText.append(this.tablaManager.getLanguageText("text.worldLevel"));
                    } else if (this.matchData.getRank() == Rank.ADVANCED) {
                        additionalText.append(", ");
                        additionalText.append(this.tablaManager.getLanguageText("text.advancedLevel"));
                    } else if (this.matchData.getRank() == Rank.NOVICE) {
                        additionalText.append(", ");
                        additionalText.append(this.tablaManager.getLanguageText("text.noviceLevel"));
                    }
                }
                if (StringUtil.isNotEmpty((String)this.matchData.getCategory())) {
                    category.append(" / ");
                    category.append((CharSequence)additionalText);
                }
            } else if (this.matchData.getMatchRound() == MatchRound.FINALS) {
                category.append(" / ");
                category.append(this.tablaManager.getLanguageText("text.finals"));
            } else if (this.matchData.getMatchRound() == MatchRound.HALF_FINALS) {
                category.append(" / ");
                category.append(this.tablaManager.getLanguageText("text.halfFinals"));
            } else if (this.matchData.getMatchRound() == MatchRound.QUARTER_FINALS) {
                category.append(" / ");
                category.append(this.tablaManager.getLanguageText("text.quarterFinals"));
            } else if (this.matchData.getMatchRound() == MatchRound.EIGHTH_FINALS) {
                category.append(" / ");
                category.append(this.tablaManager.getLanguageText("text.eightFinals"));
            } else if (this.matchData.getMatchRound() == MatchRound.SIXTEEN_FINALS) {
                category.append(" / ");
                category.append(this.tablaManager.getLanguageText("text.sixtinFinals"));
            } else if (this.matchData.getMatchRound() == MatchRound.THIRTY_TWO_FINALS) {
                category.append(" / ");
                category.append(this.tablaManager.getLanguageText("text.tirtytwoFinals"));
            } else if (this.matchData.getMatchRound() == MatchRound.FOR_3RD_PLACE) {
                category.append(" / ");
                category.append(this.tablaManager.getLanguageText("text.for3rdPlace"));
            } else if (this.matchData.getMatchRound() == MatchRound.REPECHAGE) {
                category.append(" / ");
                category.append(this.tablaManager.getLanguageText("text.repechage"));
            }
            matchInfoResponseData.setCategory(category.toString());
            this.objectMapper.writeValue(outputStream, (Object)matchInfoResponseData);
            outputStream.close();
        }
        catch (Throwable e) {
            LOGGER.error("Error processing request", e);
            this.sendError(httpExchange, HttpStatus.INTERNAL_SERVER_ERROR.value(), "Error processing request");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendError(HttpExchange httpExchange, int status, String message) {
        OutputStream outputStream = null;
        try {
            httpExchange.sendResponseHeaders(status, 0L);
            outputStream = httpExchange.getResponseBody();
            outputStream.write(message.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOGGER.error("Error sending error", (Throwable)e);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

