/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.vertical;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.DuoPoints;
import si.nevensrok.jtekma.tabla.common.FightPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.NewazaPoints;
import si.nevensrok.jtekma.tabla.common.TableType;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.fw.TimeTracker;
import si.nevensrok.jtekma.tabla.gui.MatchPanel;
import si.nevensrok.jtekma.tabla.gui.TextSource;
import si.nevensrok.jtekma.tabla.gui.WindowKeyListener;
import si.nevensrok.jtekma.tabla.gui.duo.DuoTextFieldKeyListener;
import si.nevensrok.jtekma.tabla.gui.vertical.InfoPanel;
import si.nevensrok.jtekma.tabla.gui.vertical.VerticalDuoPointCombine;
import si.nevensrok.jtekma.tabla.gui.vertical.VerticalDuoPointsPanel;
import si.nevensrok.jtekma.tabla.gui.vertical.VerticalFightPointsPanel;
import si.nevensrok.jtekma.tabla.gui.vertical.VerticalNewazaPointsPanel;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class VerticalMatchPanel
extends JPanel
implements InitializingBean,
MatchPanel {
    private JPanel competitorsPanel = new JPanel();
    private JPanel competitor1Panel = new JPanel();
    private JPanel competitor2Panel = new JPanel();
    private JLabel points1label = new JLabel();
    private JLabel points2label = new JLabel();
    private JPanel competitor1TopPanel = new JPanel();
    private JLabel name1label = new JLabel();
    private JLabel club1label = new JLabel();
    private JPanel competitor2TopPanel = new JPanel();
    private JLabel name2label = new JLabel();
    private JLabel club2label = new JLabel();
    private JPanel bottomPanel = new JPanel();
    private InfoPanel infoPanel = new InfoPanel();
    private VerticalFightPointsPanel fightPointsPanel1 = new VerticalFightPointsPanel();
    private VerticalFightPointsPanel fightPointsPanel2;
    private VerticalDuoPointsPanel duoPointsPanel1;
    private VerticalDuoPointsPanel duoPointsPanel2;
    private VerticalNewazaPointsPanel newazaPointsPanels1;
    private VerticalNewazaPointsPanel newazaPointsPanels2;
    private MatchData matchData;
    private JFrame mainWindow;
    private TextSource textSource;
    boolean flipped = false;
    private VerticalDuoPointCombine verticalDuoPointCombine;

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
        this.infoPanel.setMatchData(matchData);
        this.fightPointsPanel1.setMatchData(matchData);
        this.fightPointsPanel2.setMatchData(matchData);
        this.duoPointsPanel1.setMatchData(matchData);
        this.duoPointsPanel2.setMatchData(matchData);
        this.newazaPointsPanels1.setMatchData(matchData);
        this.newazaPointsPanels2.setMatchData(matchData);
    }

    public void setTimeTracker(TimeTracker timeTracker) {
        this.infoPanel.setTimeTracker(timeTracker);
    }

    public void setFightPoints(FightPoints fightPoints) {
        this.fightPointsPanel1.setFightPoints(fightPoints);
        this.fightPointsPanel2.setFightPoints(fightPoints);
    }

    public void setDuoPoints(DuoPoints duoPoints) {
        this.duoPointsPanel1.setDuoPoints(duoPoints);
        this.duoPointsPanel2.setDuoPoints(duoPoints);
    }

    public void setNewazaPoints(NewazaPoints newazaPoints) {
        this.newazaPointsPanels1.setNewazaPoints(newazaPoints);
        this.newazaPointsPanels2.setNewazaPoints(newazaPoints);
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.fightPointsPanel1.setTablaManager(tablaManager);
        this.fightPointsPanel2.setTablaManager(tablaManager);
        this.duoPointsPanel1.setTablaManager(tablaManager);
        this.duoPointsPanel2.setTablaManager(tablaManager);
        this.newazaPointsPanels1.setTablaManager(tablaManager);
        this.newazaPointsPanels2.setTablaManager(tablaManager);
    }

    public void setWindowKeyListener(WindowKeyListener windowKeyListener) {
        this.duoPointsPanel1.setWindowKeyListener(windowKeyListener);
        this.duoPointsPanel2.setWindowKeyListener(windowKeyListener);
    }

    public void setMainWindow(JFrame mainWindow) {
        this.mainWindow = mainWindow;
    }

    public void setTextSource(TextSource textSource) {
        this.textSource = textSource;
    }

    public VerticalMatchPanel() {
        this.fightPointsPanel1.setCompetitorType(CompetitorType.COMPETITOR1);
        this.fightPointsPanel2 = new VerticalFightPointsPanel();
        this.fightPointsPanel2.setCompetitorType(CompetitorType.COMPETITOR2);
        this.duoPointsPanel1 = new VerticalDuoPointsPanel();
        this.duoPointsPanel1.setCompetitorType(CompetitorType.COMPETITOR1);
        this.duoPointsPanel2 = new VerticalDuoPointsPanel();
        this.duoPointsPanel2.setCompetitorType(CompetitorType.COMPETITOR2);
        this.newazaPointsPanels1 = new VerticalNewazaPointsPanel();
        this.newazaPointsPanels1.setCompetitorType(CompetitorType.COMPETITOR1);
        this.newazaPointsPanels2 = new VerticalNewazaPointsPanel();
        this.newazaPointsPanels2.setCompetitorType(CompetitorType.COMPETITOR2);
        this.setLayout(new BorderLayout());
        this.competitorsPanel.setLayout(new GridLayout(1, 2));
        this.add((Component)this.competitorsPanel, "Center");
        this.competitorsPanel.add(this.competitor1Panel);
        this.competitor1Panel.setLayout(new BorderLayout());
        this.competitor1TopPanel.setLayout(new GridLayout(2, 1));
        this.competitor1TopPanel.add(this.name1label);
        this.competitor1TopPanel.add(this.club1label);
        this.competitor1Panel.add((Component)this.competitor1TopPanel, "North");
        this.competitor1Panel.add((Component)this.points1label, "Center");
        this.competitorsPanel.add(this.competitor2Panel);
        this.competitor2Panel.setLayout(new BorderLayout());
        this.competitor2TopPanel.setLayout(new GridLayout(2, 1));
        this.competitor2TopPanel.add(this.name2label);
        this.competitor2TopPanel.add(this.club2label);
        this.competitor2Panel.add((Component)this.competitor2TopPanel, "North");
        this.competitor2Panel.add((Component)this.points2label, "Center");
        this.bottomPanel.setLayout(new GridLayout(1, 3));
        this.add((Component)this.bottomPanel, "South");
        this.verticalDuoPointCombine = new VerticalDuoPointCombine();
        this.verticalDuoPointCombine.setDuoPointsPanel1(this.duoPointsPanel1);
        this.verticalDuoPointCombine.setDuoPointsPanel2(this.duoPointsPanel2);
        DuoTextFieldKeyListener duoTextFieldKeyListener = new DuoTextFieldKeyListener();
        duoTextFieldKeyListener.setDuoPointsPanel(this.verticalDuoPointCombine);
        this.duoPointsPanel1.setDuoTextFieldKeyListener(duoTextFieldKeyListener);
        this.duoPointsPanel2.setDuoTextFieldKeyListener(duoTextFieldKeyListener);
    }

    public void afterPropertiesSet() throws Exception {
        this.redrawElements();
    }

    @Override
    public void redrawElements() {
        this.redrawElements(false);
    }

    @Override
    public void redrawElements(boolean noDataChange) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean changeSide = VerticalMatchPanel.this.flipped != VerticalMatchPanel.this.matchData.isFlipCompetitors();
                VerticalMatchPanel.this.flipped = VerticalMatchPanel.this.matchData.isFlipCompetitors();
                if (changeSide) {
                    VerticalMatchPanel.this.competitorsPanel.remove(VerticalMatchPanel.this.competitor1Panel);
                    VerticalMatchPanel.this.competitorsPanel.remove(VerticalMatchPanel.this.competitor2Panel);
                    if (VerticalMatchPanel.this.flipped) {
                        VerticalMatchPanel.this.competitorsPanel.add(VerticalMatchPanel.this.competitor2Panel);
                        VerticalMatchPanel.this.competitorsPanel.add(VerticalMatchPanel.this.competitor1Panel);
                    } else {
                        VerticalMatchPanel.this.competitorsPanel.add(VerticalMatchPanel.this.competitor1Panel);
                        VerticalMatchPanel.this.competitorsPanel.add(VerticalMatchPanel.this.competitor2Panel);
                    }
                }
                VerticalMatchPanel.this.points1label.setOpaque(true);
                VerticalMatchPanel.this.points1label.setForeground(Constants.COMPETITOR_1_FG_COLOR);
                VerticalMatchPanel.this.points1label.setBackground(Constants.COMPETITOR_1_BG_COLOR);
                VerticalMatchPanel.this.points1label.setHorizontalAlignment(0);
                FontSizeUtil.refitFontSize(Constants.FONT, VerticalMatchPanel.this.points1label);
                VerticalMatchPanel.this.points2label.setOpaque(true);
                VerticalMatchPanel.this.points2label.setForeground(Constants.COMPETITOR_2_FG_COLOR);
                VerticalMatchPanel.this.points2label.setBackground(Constants.COMPETITOR_2_BG_COLOR);
                VerticalMatchPanel.this.points2label.setHorizontalAlignment(0);
                FontSizeUtil.refitFontSize(Constants.FONT, VerticalMatchPanel.this.points2label);
                int topHeight = VerticalMatchPanel.this.mainWindow.getHeight() / 8;
                if (topHeight < 70) {
                    topHeight = 70;
                }
                VerticalMatchPanel.this.competitor1TopPanel.setBackground(Constants.COMPETITOR_1_BG_COLOR);
                VerticalMatchPanel.this.name1label.setPreferredSize(new Dimension(0, topHeight));
                VerticalMatchPanel.this.name1label.setForeground(Constants.COMPETITOR_1_FG_COLOR);
                VerticalMatchPanel.this.name1label.setHorizontalAlignment(0);
                VerticalMatchPanel.this.club1label.setPreferredSize(new Dimension(0, topHeight));
                VerticalMatchPanel.this.club1label.setForeground(Constants.COMPETITOR_1_FG_COLOR);
                VerticalMatchPanel.this.club1label.setHorizontalAlignment(0);
                VerticalMatchPanel.this.competitor2TopPanel.setBackground(Constants.COMPETITOR_2_BG_COLOR);
                VerticalMatchPanel.this.name2label.setPreferredSize(new Dimension(0, topHeight));
                VerticalMatchPanel.this.name2label.setForeground(Constants.COMPETITOR_2_FG_COLOR);
                VerticalMatchPanel.this.name2label.setHorizontalAlignment(0);
                VerticalMatchPanel.this.club2label.setPreferredSize(new Dimension(0, topHeight));
                VerticalMatchPanel.this.club2label.setForeground(Constants.COMPETITOR_2_FG_COLOR);
                VerticalMatchPanel.this.club2label.setHorizontalAlignment(0);
                VerticalMatchPanel.this.infoPanel.setPreferredSize(new Dimension(190, 0));
                VerticalMatchPanel.this.name1label.setText(VerticalMatchPanel.this.matchData.getName1());
                FontSizeUtil.refitFontSize(Constants.FONT, VerticalMatchPanel.this.name1label);
                VerticalMatchPanel.this.club1label.setText(VerticalMatchPanel.this.matchData.getClub1());
                FontSizeUtil.refitFontSize(Constants.FONT, VerticalMatchPanel.this.club1label);
                VerticalMatchPanel.this.name2label.setText(VerticalMatchPanel.this.matchData.getName2());
                FontSizeUtil.refitFontSize(Constants.FONT, VerticalMatchPanel.this.name2label);
                VerticalMatchPanel.this.club2label.setText(VerticalMatchPanel.this.matchData.getClub2());
                FontSizeUtil.refitFontSize(Constants.FONT, VerticalMatchPanel.this.club2label);
                int bottomHeight = VerticalMatchPanel.this.mainWindow.getHeight() / 3;
                if (bottomHeight < 100) {
                    bottomHeight = 100;
                }
                VerticalMatchPanel.this.bottomPanel.setPreferredSize(new Dimension(0, bottomHeight));
                if (VerticalMatchPanel.this.flipped) {
                    VerticalMatchPanel.this.competitorsPanel.setBackground(Constants.COMPETITOR_1_BG_COLOR);
                    VerticalMatchPanel.this.bottomPanel.setBackground(Constants.COMPETITOR_1_BG_COLOR);
                } else {
                    VerticalMatchPanel.this.competitorsPanel.setBackground(Constants.COMPETITOR_2_BG_COLOR);
                    VerticalMatchPanel.this.bottomPanel.setBackground(Constants.COMPETITOR_2_BG_COLOR);
                }
                if (VerticalMatchPanel.this.matchData.getTableType() == TableType.FIGHT) {
                    boolean change = true;
                    for (Component component : VerticalMatchPanel.this.bottomPanel.getComponents()) {
                        if (component != VerticalMatchPanel.this.fightPointsPanel1) continue;
                        change = false;
                        break;
                    }
                    if (change || changeSide) {
                        VerticalMatchPanel.this.bottomPanel.removeAll();
                        if (VerticalMatchPanel.this.flipped) {
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.fightPointsPanel2, 0);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.infoPanel, 1);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.fightPointsPanel1, 2);
                        } else {
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.fightPointsPanel1, 0);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.infoPanel, 1);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.fightPointsPanel2, 2);
                        }
                        VerticalMatchPanel.this.revalidate();
                        VerticalMatchPanel.this.repaint();
                        VerticalMatchPanel.this.mainWindow.requestFocus();
                    }
                } else if (VerticalMatchPanel.this.matchData.getTableType() == TableType.DUO) {
                    boolean change = true;
                    for (Component component : VerticalMatchPanel.this.bottomPanel.getComponents()) {
                        if (component != VerticalMatchPanel.this.duoPointsPanel1) continue;
                        change = false;
                        break;
                    }
                    if (change || changeSide) {
                        VerticalMatchPanel.this.bottomPanel.removeAll();
                        if (VerticalMatchPanel.this.flipped) {
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.duoPointsPanel2, 0);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.infoPanel, 1);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.duoPointsPanel1, 2);
                        } else {
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.duoPointsPanel1, 0);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.infoPanel, 1);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.duoPointsPanel2, 2);
                        }
                        VerticalMatchPanel.this.revalidate();
                        VerticalMatchPanel.this.repaint();
                    }
                } else if (VerticalMatchPanel.this.matchData.getTableType() == TableType.NEWAZA) {
                    boolean change = true;
                    for (Component component : VerticalMatchPanel.this.bottomPanel.getComponents()) {
                        if (component != VerticalMatchPanel.this.newazaPointsPanels1) continue;
                        change = false;
                        break;
                    }
                    if (change || changeSide) {
                        VerticalMatchPanel.this.bottomPanel.removeAll();
                        if (VerticalMatchPanel.this.flipped) {
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.newazaPointsPanels2, 0);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.infoPanel, 1);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.newazaPointsPanels1, 2);
                        } else {
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.newazaPointsPanels1, 0);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.infoPanel, 1);
                            VerticalMatchPanel.this.bottomPanel.add((Component)VerticalMatchPanel.this.newazaPointsPanels2, 2);
                        }
                        VerticalMatchPanel.this.revalidate();
                        VerticalMatchPanel.this.repaint();
                        VerticalMatchPanel.this.mainWindow.requestFocus();
                    }
                }
                VerticalMatchPanel.this.fightPointsPanel1.redrawElements();
                VerticalMatchPanel.this.fightPointsPanel2.redrawElements();
                VerticalMatchPanel.this.duoPointsPanel1.redrawElements();
                VerticalMatchPanel.this.duoPointsPanel2.redrawElements();
                VerticalMatchPanel.this.newazaPointsPanels1.redrawElements();
                VerticalMatchPanel.this.newazaPointsPanels2.redrawElements();
                VerticalMatchPanel.this.infoPanel.redrawElements();
            }
        });
    }

    @Override
    public void setPoints1(float points) {
        final String text = this.matchData.getTableType() == TableType.FIGHT || this.matchData.getTableType() == TableType.NEWAZA ? Constants.FIGHT_POINTS_FORMAT.format(points) : Constants.DUO_POINTS_FORMAT.format(points);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                VerticalMatchPanel.this.points1label.setText(text);
                FontSizeUtil.refitFontSize(Constants.FONT, VerticalMatchPanel.this.points1label);
            }
        });
    }

    @Override
    public void setPoints2(float points) {
        final String text = this.matchData.getTableType() == TableType.FIGHT || this.matchData.getTableType() == TableType.NEWAZA ? Constants.FIGHT_POINTS_FORMAT.format(points) : Constants.DUO_POINTS_FORMAT.format(points);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                VerticalMatchPanel.this.points2label.setText(text);
                FontSizeUtil.refitFontSize(Constants.FONT, VerticalMatchPanel.this.points2label);
            }
        });
    }

    @Override
    public void setWinner1() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                VerticalMatchPanel.this.name1label.setText(VerticalMatchPanel.this.textSource.getLanguageText("text.winner"));
                FontSizeUtil.refitFontSize(Constants.FONT, VerticalMatchPanel.this.name1label);
                VerticalMatchPanel.this.club1label.setText("");
                VerticalMatchPanel.this.name2label.setText("");
                VerticalMatchPanel.this.club2label.setText("");
            }
        });
    }

    @Override
    public void setWinner2() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                VerticalMatchPanel.this.name2label.setText(VerticalMatchPanel.this.textSource.getLanguageText("text.winner"));
                FontSizeUtil.refitFontSize(Constants.FONT, VerticalMatchPanel.this.name2label);
                VerticalMatchPanel.this.name1label.setText("");
                VerticalMatchPanel.this.club1label.setText("");
                VerticalMatchPanel.this.club2label.setText("");
            }
        });
    }

    @Override
    public void resetDuoPoints() {
        this.verticalDuoPointCombine.resetPoints();
    }

    @Override
    public void recalculateDuoPoints() {
        this.verticalDuoPointCombine.recalculateRoundPoints();
    }

    @Override
    public void selectFirstDuoField() {
        this.verticalDuoPointCombine.selectFirstField();
    }
}

