/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal.newaza;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.NewazaPoints;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.TextSource;
import si.nevensrok.jtekma.tabla.gui.horizontal.ChallengePanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.PenaltyTracker;
import si.nevensrok.jtekma.tabla.gui.horizontal.newaza.NewazaPointBox;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class NewazaPointsPanel
extends JLabel {
    private JPanel detailsPanel = new JPanel();
    private JPanel pointsPanel = new JPanel();
    private NewazaPointBox point2Box;
    private NewazaPointBox point3Box;
    private NewazaPointBox point4Box;
    private NewazaPointBox point100Box;
    private NewazaPointBox advantageBox;
    private NewazaPointBox penaltyBox;
    private NewazaPointBox hansokumakeBox;
    private PenaltyTracker penaltyTracker;
    private ChallengePanel challengePanel;
    private JLabel totalPointsLabel = new JLabel("0");

    public NewazaPointsPanel(CompetitorType competitorType) {
        this.setLayout(new GridLayout(1, 2));
        this.detailsPanel.setLayout(null);
        this.add(this.detailsPanel);
        this.totalPointsLabel.setHorizontalAlignment(0);
        this.add(this.totalPointsLabel);
        this.point2Box = new NewazaPointBox("P2", competitorType, PointType.POINT2);
        this.point3Box = new NewazaPointBox("P3", competitorType, PointType.POINT3);
        this.point4Box = new NewazaPointBox("P4", competitorType, PointType.POINT4);
        this.point100Box = new NewazaPointBox("P100", competitorType, PointType.POINT100);
        this.advantageBox = new NewazaPointBox("A", competitorType, PointType.ADVANTAGE);
        this.penaltyBox = new NewazaPointBox("PE", competitorType, PointType.PENALTY);
        this.hansokumakeBox = new NewazaPointBox("H", competitorType, PointType.HANSOKUMAKE);
        this.penaltyTracker = new PenaltyTracker(competitorType);
        this.challengePanel = new ChallengePanel(competitorType);
        this.pointsPanel.setLayout(new GridLayout(2, 4));
        this.pointsPanel.add(this.point2Box);
        this.pointsPanel.add(this.point3Box);
        this.pointsPanel.add(this.point4Box);
        this.pointsPanel.add(this.point100Box);
        this.pointsPanel.add(this.advantageBox);
        this.pointsPanel.add(this.penaltyBox);
        this.pointsPanel.add(this.hansokumakeBox);
        this.pointsPanel.add(new JLabel());
        this.detailsPanel.add(this.pointsPanel);
        this.detailsPanel.add(this.penaltyTracker);
        this.detailsPanel.add(this.challengePanel);
    }

    public void setNewazaPoints(NewazaPoints newazaPoints) {
        this.point2Box.setNewazaPoints(newazaPoints);
        this.point3Box.setNewazaPoints(newazaPoints);
        this.point4Box.setNewazaPoints(newazaPoints);
        this.point100Box.setNewazaPoints(newazaPoints);
        this.advantageBox.setNewazaPoints(newazaPoints);
        this.penaltyBox.setNewazaPoints(newazaPoints);
        this.hansokumakeBox.setNewazaPoints(newazaPoints);
        this.penaltyTracker.setNewazaPoints(newazaPoints);
    }

    public void setMatchData(MatchData matchData) {
        this.point2Box.setMatchData(matchData);
        this.point3Box.setMatchData(matchData);
        this.point4Box.setMatchData(matchData);
        this.point100Box.setMatchData(matchData);
        this.advantageBox.setMatchData(matchData);
        this.penaltyBox.setMatchData(matchData);
        this.hansokumakeBox.setMatchData(matchData);
        this.penaltyTracker.setMatchData(matchData);
        this.challengePanel.setMatchData(matchData);
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.point2Box.setTablaManager(tablaManager);
        this.point3Box.setTablaManager(tablaManager);
        this.point4Box.setTablaManager(tablaManager);
        this.point100Box.setTablaManager(tablaManager);
        this.advantageBox.setTablaManager(tablaManager);
        this.penaltyBox.setTablaManager(tablaManager);
        this.hansokumakeBox.setTablaManager(tablaManager);
        this.penaltyTracker.setTablaManager(tablaManager);
        this.challengePanel.setTablaManager(tablaManager);
    }

    public void setTextSource(TextSource textSource) {
        this.challengePanel.setTextSource(textSource);
        this.penaltyTracker.setTextSource(textSource);
    }

    public void setPoints(final float points) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewazaPointsPanel.this.totalPointsLabel.setText(Constants.FIGHT_POINTS_FORMAT.format(points));
                FontSizeUtil.refitFontSize(Constants.FONT, NewazaPointsPanel.this.totalPointsLabel);
            }
        });
    }

    public void redrawElements() {
        final int width = this.detailsPanel.getWidth();
        final int height = this.detailsPanel.getHeight();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int pointsPanelHeight = (int)Math.floor((float)height * 0.5f);
                NewazaPointsPanel.this.pointsPanel.setLocation(0, 0);
                NewazaPointsPanel.this.pointsPanel.setSize(width, pointsPanelHeight);
                int penaltyTrackerHeight = (int)Math.floor((float)height * 0.25f);
                NewazaPointsPanel.this.penaltyTracker.setLocation(0, pointsPanelHeight);
                NewazaPointsPanel.this.penaltyTracker.setSize(width, penaltyTrackerHeight);
                NewazaPointsPanel.this.challengePanel.setLocation(0, pointsPanelHeight + penaltyTrackerHeight);
                NewazaPointsPanel.this.challengePanel.setSize(width, height - pointsPanelHeight - penaltyTrackerHeight);
                NewazaPointsPanel.this.point2Box.redrawElements();
                NewazaPointsPanel.this.point3Box.redrawElements();
                NewazaPointsPanel.this.point4Box.redrawElements();
                NewazaPointsPanel.this.point100Box.redrawElements();
                NewazaPointsPanel.this.advantageBox.redrawElements();
                NewazaPointsPanel.this.penaltyBox.redrawElements();
                NewazaPointsPanel.this.hansokumakeBox.redrawElements();
                NewazaPointsPanel.this.penaltyTracker.redrawElements();
                NewazaPointsPanel.this.challengePanel.redrawElements();
                FontSizeUtil.refitFontSize(Constants.FONT, NewazaPointsPanel.this.totalPointsLabel);
                NewazaPointsPanel.this.repaint();
            }
        });
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.detailsPanel != null) {
            this.detailsPanel.setBackground(bg);
        }
        if (this.pointsPanel != null) {
            this.pointsPanel.setBackground(bg);
        }
        if (this.point2Box != null) {
            this.point2Box.setBackground(bg);
        }
        if (this.point3Box != null) {
            this.point3Box.setBackground(bg);
        }
        if (this.point4Box != null) {
            this.point4Box.setBackground(bg);
        }
        if (this.point100Box != null) {
            this.point100Box.setBackground(bg);
        }
        if (this.advantageBox != null) {
            this.advantageBox.setBackground(bg);
        }
        if (this.penaltyBox != null) {
            this.penaltyBox.setBackground(bg);
        }
        if (this.hansokumakeBox != null) {
            this.hansokumakeBox.setBackground(bg);
        }
        if (this.challengePanel != null) {
            this.challengePanel.setBackground(bg);
        }
        if (this.penaltyTracker != null) {
            this.penaltyTracker.setBackground(bg);
        }
        if (this.totalPointsLabel != null) {
            this.totalPointsLabel.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.detailsPanel != null) {
            this.detailsPanel.setForeground(fg);
        }
        if (this.pointsPanel != null) {
            this.pointsPanel.setForeground(fg);
        }
        if (this.point2Box != null) {
            this.point2Box.setForeground(fg);
        }
        if (this.point3Box != null) {
            this.point3Box.setForeground(fg);
        }
        if (this.point4Box != null) {
            this.point4Box.setForeground(fg);
        }
        if (this.point100Box != null) {
            this.point100Box.setForeground(fg);
        }
        if (this.advantageBox != null) {
            this.advantageBox.setForeground(fg);
        }
        if (this.penaltyBox != null) {
            this.penaltyBox.setForeground(fg);
        }
        if (this.hansokumakeBox != null) {
            this.hansokumakeBox.setForeground(fg);
        }
        if (this.challengePanel != null) {
            this.challengePanel.setForeground(fg);
        }
        if (this.penaltyTracker != null) {
            this.penaltyTracker.setForeground(fg);
        }
        if (this.totalPointsLabel != null) {
            this.totalPointsLabel.setForeground(fg);
        }
    }
}

