/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.MatchPanel;

public class TablaWindow
extends JFrame
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TablaWindow.class);
    private ApplicationContext applicationContext;
    private KeyListener keyListener;
    private JPanel matchPanel;
    private MatchData matchData;
    private TablaManager tablaManager;
    private boolean fullScreen = true;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setKeyListener(KeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public void setMatchPanel(JPanel matchPanel) {
        this.matchPanel = matchPanel;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
    }

    public void setFullScreen(boolean fullScreen) {
        this.fullScreen = fullScreen;
    }

    public String getLanguageText(String key) {
        return this.applicationContext.getMessage(key, null, key, this.matchData.getLocale());
    }

    public TablaWindow() {
        this.setDefaultCloseOperation(0);
        this.setTitle("JTekma2 - tabla");
        this.setLayout(new BorderLayout());
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.setDefaultFocusTraversalKeys(0, new HashSet());
        kfm.setDefaultFocusTraversalKeys(1, new HashSet());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (TablaWindow.this.applicationContext instanceof AbstractApplicationContext) {
                    AbstractApplicationContext abstractApplicationContext = (AbstractApplicationContext)TablaWindow.this.applicationContext;
                    abstractApplicationContext.close();
                } else {
                    LOGGER.warn("Can't destroy application context. Stopping java process");
                    System.exit(0);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (TablaWindow.this.matchPanel instanceof MatchPanel) {
                    ((MatchPanel)((Object)TablaWindow.this.matchPanel)).redrawElements();
                }
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        if (this.keyListener != null) {
            this.addKeyListener(this.keyListener);
        }
        this.add((Component)this.matchPanel, "Center");
        if (this.fullScreen) {
            this.setUndecorated(true);
            this.setAlwaysOnTop(true);
            this.resetWindowLocation();
        } else {
            this.setSize(1024, 768);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TablaWindow.this.setVisible(true);
                TablaWindow.this.tablaManager.resetTable();
            }
        });
    }

    public void destroy() throws Exception {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TablaWindow.this.setVisible(false);
                TablaWindow.this.dispose();
            }
        });
    }

    public void showHosekomiEndedMessage() {
        final TablaWindow window = this;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(window, TablaWindow.this.getLanguageText("text.hosekomiEnded"), TablaWindow.this.getLanguageText("title.info"), 1);
            }
        });
    }

    public void showDrawMessage() {
        final TablaWindow window = this;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(window, TablaWindow.this.getLanguageText("text.matchDraw"), TablaWindow.this.getLanguageText("title.info"), 2);
            }
        });
    }

    public void resetWindowLocation() {
        final Dimension screeenSize = Toolkit.getDefaultToolkit().getScreenSize();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TablaWindow.this.setLocation(0, 0);
                TablaWindow.this.setSize(screeenSize);
            }
        });
    }
}

