/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.fw;

import java.awt.EventQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.NextMatchData;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.tabla.common.Duo2023Points;
import si.nevensrok.jtekma.tabla.common.DuoPoints;
import si.nevensrok.jtekma.tabla.common.DuoPresentationPoints;
import si.nevensrok.jtekma.tabla.common.FightPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.NewazaPoints;
import si.nevensrok.jtekma.tabla.common.TableType;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.fw.TablaServiceClient;
import si.nevensrok.jtekma.tabla.gui.ChallengeDialog;
import si.nevensrok.jtekma.tabla.gui.InfoWindow;
import si.nevensrok.jtekma.tabla.gui.InjuryTimeDialog;
import si.nevensrok.jtekma.tabla.gui.MatchPanel;
import si.nevensrok.jtekma.tabla.gui.TablaWindow;

public class MatchFetchOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(MatchFetchOperation.class);
    private Thread thread = new Thread("Match fetching thread"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DuoPresentation duoPresentation;
                CoupleCompetitor coupleCompetitor;
                PersonCompetitor personCompetitor;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                while (!MatchFetchOperation.this.infoWindow.isVisible()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                NextMatchData nextMatchData = null;
                final AtomicBoolean errorWhileFetching = new AtomicBoolean(true);
                for (int i = 0; i < 3; ++i) {
                    if (MatchFetchOperation.this.infoWindow.isOperationCanceled()) {
                        return;
                    }
                    MatchFetchOperation.this.infoWindow.setCurrentAttempt(i + 1);
                    try {
                        nextMatchData = MatchFetchOperation.this.tablaService.getNextMatch(MatchFetchOperation.this.matchData.getCredentials());
                        errorWhileFetching.set(false);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while fetching next match", (Throwable)e);
                        continue;
                    }
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MatchFetchOperation.this.tablaWindow.setEnabled(true);
                        MatchFetchOperation.this.infoWindow.setVisible(false);
                        MatchFetchOperation.this.infoWindow.dispose();
                        MatchFetchOperation.this.tablaWindow.requestFocus();
                    }
                });
                if (MatchFetchOperation.this.infoWindow.isOperationCanceled()) {
                    return;
                }
                LOGGER.debug("Next match data fetched {}", nextMatchData);
                if (nextMatchData == null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MatchFetchOperation.this.tablaWindow.setEnabled(true);
                            MatchFetchOperation.this.infoWindow.setVisible(false);
                            MatchFetchOperation.this.infoWindow.dispose();
                            MatchFetchOperation.this.tablaWindow.requestFocus();
                            if (errorWhileFetching.get()) {
                                JOptionPane.showMessageDialog(MatchFetchOperation.this.tablaWindow, MatchFetchOperation.this.tablaManager.getLanguageText("text.errorFetching"), MatchFetchOperation.this.tablaManager.getLanguageText("title.error"), 0);
                            } else {
                                JOptionPane.showMessageDialog(MatchFetchOperation.this.tablaWindow, MatchFetchOperation.this.tablaManager.getLanguageText("text.noMatch"), MatchFetchOperation.this.tablaManager.getLanguageText("title.error"), 0);
                            }
                        }
                    });
                    return;
                }
                MatchFetchOperation.this.tablaManager.resetTable();
                Match match = nextMatchData.getMatch();
                if (match != null) {
                    Competitor competitor2;
                    if (match.getType() == Match.Type.FIGHT) {
                        MatchFetchOperation.this.matchData.setTableType(TableType.FIGHT);
                    } else if (match.getType() == Match.Type.DUO) {
                        MatchFetchOperation.this.matchData.setTableType(TableType.DUO);
                    } else if (match.getType() == Match.Type.NEWAZA) {
                        MatchFetchOperation.this.matchData.setTableType(TableType.NEWAZA);
                    } else if (match.getType() == Match.Type.DUO2023) {
                        MatchFetchOperation.this.matchData.setTableType(TableType.DUO2023);
                    } else {
                        LOGGER.warn("Unknown match type {}", (Object)match.getType());
                    }
                    if (nextMatchData.getMatchPoints() != null) {
                        if (match.getType() == Match.Type.FIGHT) {
                            MatchFetchOperation.this.fightPoints.setMatchPoints(nextMatchData.getMatchPoints(), MatchFetchOperation.this.competitionRules);
                        } else if (match.getType() == Match.Type.DUO) {
                            MatchFetchOperation.this.duoPoints.setMatchPoints(nextMatchData.getMatchPoints());
                        } else if (match.getType() == Match.Type.DUO2023) {
                            MatchFetchOperation.this.matchData.setRound((Round)ObjectUtil.ifNull((Object)nextMatchData.getRound(), (Object)Round.ROUND_1));
                            MatchFetchOperation.this.matchData.setRank((Rank)ObjectUtil.ifNull((Object)nextMatchData.getRank(), (Object)Rank.WORLD_LEVEL));
                            MatchFetchOperation.this.matchData.setAge((Integer)ObjectUtil.ifNull((Object)nextMatchData.getAge(), (Object)22));
                            AgeCategoryOption ageCategoryOption = new AgeCategoryOption();
                            ageCategoryOption.setAge(nextMatchData.getAge());
                            Set attacks = MatchFetchOperation.this.competitionRules.getDuoPresentationAttacks(ageCategoryOption, MatchFetchOperation.this.matchData.getRound().ordinal() + 1);
                            MatchFetchOperation.this.duo2023Points.setMatchPoints(nextMatchData.getMatchPoints(), attacks);
                        } else if (match.getType() == Match.Type.NEWAZA) {
                            MatchFetchOperation.this.newazaPoints.setMatchPoints(nextMatchData.getMatchPoints());
                        }
                    }
                    MatchFetchOperation.this.matchData.setDuoPresentation(null);
                    MatchFetchOperation.this.matchData.setMatch(match);
                    MatchFetchOperation.this.matchData.setCategory(match.getCategory().getName());
                    Competitor competitor1 = match.getCompetitor1();
                    if (competitor1 != null) {
                        if (competitor1 instanceof PersonCompetitor) {
                            PersonCompetitor personCompetitor2 = (PersonCompetitor)competitor1;
                            MatchFetchOperation.this.matchData.setName1(personCompetitor2.getShortName());
                        }
                        if (competitor1 instanceof CoupleCompetitor) {
                            CoupleCompetitor coupleCompetitor2 = (CoupleCompetitor)competitor1;
                            MatchFetchOperation.this.matchData.setName1(coupleCompetitor2.getShortName());
                        }
                        MatchFetchOperation.this.matchData.setClub1(competitor1.getClub().getShortName());
                    }
                    if ((competitor2 = match.getCompetitor2()) != null) {
                        if (competitor2 instanceof PersonCompetitor) {
                            personCompetitor = (PersonCompetitor)competitor2;
                            MatchFetchOperation.this.matchData.setName2(personCompetitor.getShortName());
                        }
                        if (competitor2 instanceof CoupleCompetitor) {
                            coupleCompetitor = (CoupleCompetitor)competitor2;
                            MatchFetchOperation.this.matchData.setName2(coupleCompetitor.getShortName());
                        }
                        MatchFetchOperation.this.matchData.setClub2(competitor2.getClub().getShortName());
                    }
                }
                if ((duoPresentation = nextMatchData.getDuoPresentation()) != null) {
                    if (nextMatchData.getDuoPresentationPoints() != null) {
                        MatchFetchOperation.this.matchData.setRound((Round)ObjectUtil.ifNull((Object)nextMatchData.getRound(), (Object)Round.ROUND_1));
                        MatchFetchOperation.this.matchData.setRank((Rank)ObjectUtil.ifNull((Object)nextMatchData.getRank(), (Object)Rank.WORLD_LEVEL));
                        MatchFetchOperation.this.matchData.setAge((Integer)ObjectUtil.ifNull((Object)nextMatchData.getAge(), (Object)22));
                        AgeCategoryOption ageCategoryOption = new AgeCategoryOption();
                        ageCategoryOption.setAge(nextMatchData.getAge());
                        Set attacks = MatchFetchOperation.this.competitionRules.getDuoPresentationAttacks(ageCategoryOption, MatchFetchOperation.this.matchData.getRound().ordinal() + 1);
                        MatchFetchOperation.this.duoPresentationPoints.setMatchPoints(nextMatchData.getDuoPresentationPoints(), attacks);
                    }
                    MatchFetchOperation.this.matchData.setMatch(null);
                    MatchFetchOperation.this.matchData.setDuoPresentation(duoPresentation);
                    MatchFetchOperation.this.matchData.setCategory(duoPresentation.getCategory().getName());
                    Competitor competitor = duoPresentation.getCompetitor();
                    if (competitor != null) {
                        if (competitor instanceof PersonCompetitor) {
                            personCompetitor = (PersonCompetitor)competitor;
                            MatchFetchOperation.this.matchData.setName1(personCompetitor.getShortName());
                        }
                        if (competitor instanceof CoupleCompetitor) {
                            coupleCompetitor = (CoupleCompetitor)competitor;
                            MatchFetchOperation.this.matchData.setName1(coupleCompetitor.getShortName());
                        }
                        MatchFetchOperation.this.matchData.setClub1(competitor.getClub().getShortName());
                    }
                    MatchFetchOperation.this.matchData.setTableType(TableType.DUO_PRESENTATION);
                }
                if (nextMatchData.getMatchTime() != null) {
                    MatchFetchOperation.this.matchData.setTimeLeft(nextMatchData.getMatchTime().longValue() * 1000L);
                }
                if (nextMatchData.getHosekomiTime() != null) {
                    MatchFetchOperation.this.matchData.setMaximumHosekomiTime(nextMatchData.getHosekomiTime().longValue() * 1000L);
                }
                if (nextMatchData.getRules() != null) {
                    MatchFetchOperation.this.matchData.setRules(nextMatchData.getRules());
                }
                if (nextMatchData.getInjuryTime1() != null) {
                    MatchFetchOperation.this.injuryTimeDialog.setInjuryTime1(nextMatchData.getInjuryTime1() * 1000);
                }
                if (nextMatchData.getInjuryTime2() != null) {
                    MatchFetchOperation.this.injuryTimeDialog.setInjuryTime2(nextMatchData.getInjuryTime2() * 1000);
                }
                if (nextMatchData.getChallengeAvailable1() == null || nextMatchData.getChallengeAvailable1().booleanValue()) {
                    MatchFetchOperation.this.matchData.setChallengeAvailable1(true);
                } else {
                    MatchFetchOperation.this.matchData.setChallengeAvailable1(false);
                }
                if (nextMatchData.getChallengeAvailable2() == null || nextMatchData.getChallengeAvailable2().booleanValue()) {
                    MatchFetchOperation.this.matchData.setChallengeAvailable2(true);
                } else {
                    MatchFetchOperation.this.matchData.setChallengeAvailable2(false);
                }
                if (nextMatchData.getChallengesWon1() != null && nextMatchData.getChallengesWon1() >= 0) {
                    MatchFetchOperation.this.matchData.setChallengesWon1(nextMatchData.getChallengesWon1());
                } else {
                    MatchFetchOperation.this.matchData.setChallengesWon1(0);
                }
                if (nextMatchData.getChallengesWon2() != null && nextMatchData.getChallengesWon2() >= 0) {
                    MatchFetchOperation.this.matchData.setChallengesWon2(nextMatchData.getChallengesWon2());
                } else {
                    MatchFetchOperation.this.matchData.setChallengesWon2(0);
                }
                if (nextMatchData.getChallengesLost1() != null && nextMatchData.getChallengesLost1() >= 0) {
                    MatchFetchOperation.this.matchData.setChallengesLost1(nextMatchData.getChallengesLost1());
                } else {
                    MatchFetchOperation.this.matchData.setChallengesLost1(0);
                }
                if (nextMatchData.getChallengesLost2() != null && nextMatchData.getChallengesLost2() >= 0) {
                    MatchFetchOperation.this.matchData.setChallengesLost2(nextMatchData.getChallengesLost2());
                } else {
                    MatchFetchOperation.this.matchData.setChallengesLost2(0);
                }
                if (nextMatchData.getNewazaPenaltyHansokumake() != null && nextMatchData.getNewazaPenaltyHansokumake() >= 0) {
                    MatchFetchOperation.this.matchData.setNewazaPenaltyHansokumake(nextMatchData.getNewazaPenaltyHansokumake());
                } else {
                    MatchFetchOperation.this.matchData.setNewazaPenaltyHansokumake(4);
                }
                if (((Boolean)ObjectUtil.ifNull((Object)nextMatchData.getTabletReferee(), (Object)Boolean.FALSE)).booleanValue()) {
                    MatchFetchOperation.this.matchData.setTabletReferee(true);
                    if (((Boolean)ObjectUtil.ifNull((Object)nextMatchData.getVideoReferee(), (Object)Boolean.FALSE)).booleanValue()) {
                        MatchFetchOperation.this.matchData.setVideoReferee(true);
                    } else {
                        MatchFetchOperation.this.matchData.setVideoReferee(false);
                    }
                } else {
                    MatchFetchOperation.this.matchData.setTabletReferee(false);
                    MatchFetchOperation.this.matchData.setVideoReferee(false);
                }
                MatchFetchOperation.this.matchData.setMatchRound(nextMatchData.getMatchRound());
                MatchFetchOperation.this.tablaManager.recalculatePoints();
                MatchFetchOperation.this.challengeDialog.resetData();
                MatchFetchOperation.this.matchPanel.redrawElements();
                if (!(MatchFetchOperation.this.matchData.getTableType() != TableType.DUO && MatchFetchOperation.this.matchData.getTableType() != TableType.DUO2023 && MatchFetchOperation.this.matchData.getTableType() != TableType.DUO_PRESENTATION || MatchFetchOperation.this.matchData.isTabletReferee() || MatchFetchOperation.this.matchData.isVideoReferee())) {
                    MatchFetchOperation.this.matchPanel.selectFirstDuoField();
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MatchFetchOperation.this.tablaWindow.requestFocus();
                        }
                    });
                }
            }
            finally {
                MatchFetchOperation.this.tablaManager.setFetchingMatch(false);
            }
        }
    };
    private InfoWindow infoWindow;
    private TablaServiceClient tablaService;
    private MatchData matchData;
    private TablaWindow tablaWindow;
    private TablaManager tablaManager;
    private FightPoints fightPoints;
    private DuoPoints duoPoints;
    private Duo2023Points duo2023Points;
    private DuoPresentationPoints duoPresentationPoints;
    private NewazaPoints newazaPoints;
    private CompetitionRules competitionRules;
    private InjuryTimeDialog injuryTimeDialog;
    private ChallengeDialog challengeDialog;
    private MatchPanel matchPanel;

    public void setInfoWindow(InfoWindow infoWindow) {
        this.infoWindow = infoWindow;
    }

    public void setTablaService(TablaServiceClient tablaService) {
        this.tablaService = tablaService;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTablaWindow(TablaWindow tablaWindow) {
        this.tablaWindow = tablaWindow;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
    }

    public void setFightPoints(FightPoints fightPoints) {
        this.fightPoints = fightPoints;
    }

    public void setDuoPoints(DuoPoints duoPoints) {
        this.duoPoints = duoPoints;
    }

    public void setDuo2023Points(Duo2023Points duo2023Points) {
        this.duo2023Points = duo2023Points;
    }

    public void setDuoPresentationPoints(DuoPresentationPoints duoPresentationPoints) {
        this.duoPresentationPoints = duoPresentationPoints;
    }

    public void setNewazaPoints(NewazaPoints newazaPoints) {
        this.newazaPoints = newazaPoints;
    }

    public void setCompetitionRules(CompetitionRules competitionRules) {
        this.competitionRules = competitionRules;
    }

    public void setInjuryTimeDialog(InjuryTimeDialog injuryTimeDialog) {
        this.injuryTimeDialog = injuryTimeDialog;
    }

    public void setChallengeDialog(ChallengeDialog challengeDialog) {
        this.challengeDialog = challengeDialog;
    }

    public void setMatchPanel(MatchPanel matchPanel) {
        this.matchPanel = matchPanel;
    }

    public void execute() {
        this.thread.start();
    }
}

