/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.fw;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.DuoPresentationPoint;
import si.nevensrok.jtekma.common.matches.DuoPresentationValidAttack;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchPartialData;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.MatchValidAttack;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.tabla.common.Duo2023Points;
import si.nevensrok.jtekma.tabla.common.DuoPresentationPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.fw.TablaServiceClient;
import si.nevensrok.jtekma.tabla.gui.MatchPanel;
import si.nevensrok.jtekma.tabla.util.MatchPointUtil;

public class FetchPartialDataOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(FetchPartialDataOperation.class);
    private Credentials credentials;
    private Match match;
    private DuoPresentation duoPresentation;
    private TablaServiceClient tablaService;
    private Duo2023Points duo2023Points;
    private DuoPresentationPoints duoPresentationPoints;
    private TablaManager tablaManager;
    private MatchPanel matchPanel;
    private MatchData matchData;

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setMatch(Match match) {
        this.match = match;
    }

    public void setDuoPresentation(DuoPresentation duoPresentation) {
        this.duoPresentation = duoPresentation;
    }

    public void setTablaService(TablaServiceClient tablaService) {
        this.tablaService = tablaService;
    }

    public void setDuo2023Points(Duo2023Points duo2023Points) {
        this.duo2023Points = duo2023Points;
    }

    public void setDuoPresentationPoints(DuoPresentationPoints duoPresentationPoints) {
        this.duoPresentationPoints = duoPresentationPoints;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
    }

    public void setMatchPanel(MatchPanel matchPanel) {
        this.matchPanel = matchPanel;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void execute() {
        LOGGER.debug("Fetching match partial data");
        try {
            MatchPartialData matchPartialData = null;
            if (this.match != null) {
                matchPartialData = this.tablaService.getPartialData(this.credentials, this.match);
            } else if (this.duoPresentation != null) {
                matchPartialData = this.tablaService.getPartialData(this.credentials, this.duoPresentation);
            }
            if (matchPartialData != null) {
                if (matchPartialData.getMatch() != null && matchPartialData.getMatchPoints() != null) {
                    if (matchPartialData.getMatch().getType() == Match.Type.DUO2023) {
                        boolean bl;
                        LinkedHashSet<MatchPoint> points = new LinkedHashSet<MatchPoint>();
                        boolean referee1points = false;
                        boolean referee2points = false;
                        boolean referee3points = false;
                        boolean vrRefereePoints = false;
                        for (MatchPoint matchPoint : matchPartialData.getMatchPoints()) {
                            if (matchPoint.getPointType() == PointType.JUDGE) {
                                if (matchPoint.getPart() == 1) {
                                    boolean attackValid = true;
                                    MatchValidAttack matchValidAttack = matchPartialData.getMatchValidAttacks().stream().filter(va -> va.getSeries() == matchPoint.getSeries() && va.getAttack().equals(matchPoint.getAttack()) && va.getCompetitor().equals(matchPoint.getCompetitor().ordinal() + 1)).findFirst().orElse(null);
                                    if (matchValidAttack != null) {
                                        attackValid = (Boolean)ObjectUtil.ifNull((Object)matchValidAttack.getAttackValid(), (Object)Boolean.TRUE);
                                    }
                                    if (!attackValid) continue;
                                    points.add(matchPoint);
                                    continue;
                                }
                                points.add(matchPoint);
                                continue;
                            }
                            if (matchPoint.getPointType() != PointType.PENALTY && matchPoint.getPointType() != PointType.VARIETY_SCORE_POINTS) continue;
                            points.add(matchPoint);
                        }
                        for (Map.Entry entry : matchPartialData.getFinalResult().entrySet()) {
                            if ((Integer)entry.getKey() == 1) {
                                referee1points = (Boolean)entry.getValue();
                                continue;
                            }
                            if ((Integer)entry.getKey() == 2) {
                                referee2points = (Boolean)entry.getValue();
                                continue;
                            }
                            if ((Integer)entry.getKey() == 3) {
                                referee3points = (Boolean)entry.getValue();
                                continue;
                            }
                            if ((Integer)entry.getKey() != 4) continue;
                            vrRefereePoints = (Boolean)entry.getValue();
                        }
                        Set<MatchPoint> currentPoints = this.duo2023Points.getMatchPoints();
                        boolean bl2 = true;
                        if (MatchPointUtil.haveMatchPointsChanged(currentPoints, points)) {
                            this.duo2023Points.setMatchPoints(points);
                            this.tablaManager.recalculatePoints();
                            this.matchPanel.resetDuoPoints();
                            bl = false;
                        }
                        this.matchData.setReferee1points(referee1points);
                        this.matchData.setReferee2points(referee2points);
                        this.matchData.setReferee3points(referee3points);
                        this.matchData.setVrRefereePoints(vrRefereePoints);
                        this.matchPanel.redrawElements(bl);
                    }
                } else if (matchPartialData.getDuoPresentationPoints() != null) {
                    LinkedHashSet<DuoPresentationPoint> points = new LinkedHashSet<DuoPresentationPoint>();
                    boolean referee1points = false;
                    boolean referee2points = false;
                    boolean referee3points = false;
                    boolean vrRefereePoints = false;
                    for (DuoPresentationPoint duoPresentationPoint : matchPartialData.getDuoPresentationPoints()) {
                        if (duoPresentationPoint.getType() == DuoPresentationPoint.Type.POINTS) {
                            if (duoPresentationPoint.getPart() == 1) {
                                boolean attackValid = true;
                                DuoPresentationValidAttack duoPresentationValidAttack = matchPartialData.getDuoPresentationValidAttacks().stream().filter(va -> va.getSeries() == duoPresentationPoint.getSeries() && va.getAttack().equals(duoPresentationPoint.getAttack())).findFirst().orElse(null);
                                if (duoPresentationValidAttack != null) {
                                    attackValid = (Boolean)ObjectUtil.ifNull((Object)duoPresentationValidAttack.getAttackValid(), (Object)Boolean.TRUE);
                                }
                                if (!attackValid) continue;
                                points.add(duoPresentationPoint);
                                continue;
                            }
                            points.add(duoPresentationPoint);
                            continue;
                        }
                        if (duoPresentationPoint.getType() != DuoPresentationPoint.Type.PENALTY && duoPresentationPoint.getType() != DuoPresentationPoint.Type.VARIETY_SCORE_POINTS) continue;
                        points.add(duoPresentationPoint);
                    }
                    for (Map.Entry entry : matchPartialData.getFinalResult().entrySet()) {
                        if ((Integer)entry.getKey() == 1) {
                            referee1points = (Boolean)entry.getValue();
                            continue;
                        }
                        if ((Integer)entry.getKey() == 2) {
                            referee2points = (Boolean)entry.getValue();
                            continue;
                        }
                        if ((Integer)entry.getKey() == 3) {
                            referee3points = (Boolean)entry.getValue();
                            continue;
                        }
                        if ((Integer)entry.getKey() != 4) continue;
                        vrRefereePoints = (Boolean)entry.getValue();
                    }
                    this.duoPresentationPoints.setMatchPoints(points);
                    this.matchData.setReferee1points(referee1points);
                    this.matchData.setReferee2points(referee2points);
                    this.matchData.setReferee3points(referee3points);
                    this.matchData.setVrRefereePoints(vrRefereePoints);
                    this.tablaManager.recalculatePoints();
                    this.matchPanel.resetDuoPoints();
                    this.matchPanel.redrawElements();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while sending partial data", (Throwable)e);
        }
    }
}

