/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.streams;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class DataOutputStream
extends OutputStream {
    private static final Charset UTF8 = Charset.forName("UTF8");
    private OutputStream outputStream;
    private boolean littleEndian = true;

    public DataOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public DataOutputStream(OutputStream outputStream, boolean littleEndian) {
        this.outputStream = outputStream;
        this.littleEndian = littleEndian;
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public void setLittleEndian(boolean littleEndian) {
        this.littleEndian = littleEndian;
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    public void writeBit(byte bit) throws IOException {
        this.write(bit & 1);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.write(value ? 1 : 0);
    }

    public void writeByte(byte b) throws IOException {
        this.write(b);
    }

    public void writeUnsignedByte(int b) throws IOException {
        this.write(b);
    }

    public void writeShort(short b) throws IOException {
        if (this.littleEndian) {
            this.write(b & 0xFF);
            this.write(b >> 8 & 0xFF);
        } else {
            this.write(b >> 8 & 0xFF);
            this.write(b & 0xFF);
        }
    }

    public void writeUnsignedShort(int b) throws IOException {
        if (this.littleEndian) {
            this.write(b & 0xFF);
            this.write(b >> 8 & 0xFF);
        } else {
            this.write(b >> 8 & 0xFF);
            this.write(b & 0xFF);
        }
    }

    public void writeInt(int b) throws IOException {
        if (this.littleEndian) {
            this.write(b & 0xFF);
            this.write(b >> 8 & 0xFF);
            this.write(b >> 16 & 0xFF);
            this.write(b >> 24 & 0xFF);
        } else {
            this.write(b >> 24 & 0xFF);
            this.write(b >> 16 & 0xFF);
            this.write(b >> 8 & 0xFF);
            this.write(b & 0xFF);
        }
    }

    public void writeUnsignedInt(long b) throws IOException {
        if (this.littleEndian) {
            this.write((int)(b & 0xFFL));
            this.write((int)(b >> 8 & 0xFFL));
            this.write((int)(b >> 16 & 0xFFL));
            this.write((int)(b >> 24 & 0xFFL));
        } else {
            this.write((int)(b >> 24 & 0xFFL));
            this.write((int)(b >> 16 & 0xFFL));
            this.write((int)(b >> 8 & 0xFFL));
            this.write((int)(b & 0xFFL));
        }
    }

    public void writeLong(long b) throws IOException {
        if (this.littleEndian) {
            this.write((int)(b & 0xFFL));
            this.write((int)(b >> 8 & 0xFFL));
            this.write((int)(b >> 16 & 0xFFL));
            this.write((int)(b >> 24 & 0xFFL));
            this.write((int)(b >> 32 & 0xFFL));
            this.write((int)(b >> 40 & 0xFFL));
            this.write((int)(b >> 48 & 0xFFL));
            this.write((int)(b >> 56 & 0xFFL));
        } else {
            this.write((int)(b >> 56 & 0xFFL));
            this.write((int)(b >> 48 & 0xFFL));
            this.write((int)(b >> 40 & 0xFFL));
            this.write((int)(b >> 32 & 0xFFL));
            this.write((int)(b >> 24 & 0xFFL));
            this.write((int)(b >> 16 & 0xFFL));
            this.write((int)(b >> 8 & 0xFFL));
            this.write((int)(b & 0xFFL));
        }
    }

    public void writeFloat(float b) throws IOException {
        this.writeInt(Float.floatToIntBits(b));
    }

    public void writeDouble(double b) throws IOException {
        this.writeLong(Double.doubleToLongBits(b));
    }

    public void writeAsciiCharacter(char b) throws IOException {
        this.write(b);
    }

    public void writeUtf8Character(char b) throws IOException {
        if (b <= '\u007f') {
            this.write(b);
        } else {
            byte[] bytes = new String(new char[]{b}).getBytes(UTF8);
            this.write(bytes);
        }
    }

    public void writeBytes(byte[] b) throws IOException {
        this.write(b);
    }

    public void writeAsciiString(String b) throws IOException {
        for (int i = 0; i < b.length(); ++i) {
            char c = b.charAt(i);
            this.writeAsciiCharacter(c);
        }
        this.write(0);
    }

    public void writeUtf8String(String b) throws IOException {
        byte[] bytes = b.getBytes(UTF8);
        this.write(bytes);
        this.write(0);
    }
}

