/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.tls.TlsClientProtocol;
import si.nevensrok.common.network.tcp.CustomTlsClient;
import si.nevensrok.common.ssl.BcSslSession;

public class BcSSLSocket
extends SSLSocket {
    private CustomTlsClient tlsClient;
    private TlsClientProtocol tlsClientProtocol;
    private Socket socket;
    private boolean autoClose;
    private OutputStream outputStream;
    private InputStream inputStream;
    private BcSslSession bcSslSession;

    public BcSSLSocket(CustomTlsClient tlsClient, TlsClientProtocol tlsClientProtocol, Socket socket, boolean autoClose) {
        this.tlsClient = tlsClient;
        this.tlsClientProtocol = tlsClientProtocol;
        this.socket = socket;
        this.autoClose = autoClose;
        this.outputStream = tlsClientProtocol.getOutputStream();
        this.inputStream = tlsClientProtocol.getInputStream();
        this.bcSslSession = new BcSslSession(tlsClient, socket);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return new String[0];
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return new String[0];
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
    }

    @Override
    public String[] getSupportedProtocols() {
        return new String[0];
    }

    @Override
    public String[] getEnabledProtocols() {
        return new String[0];
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
    }

    @Override
    public SSLSession getSession() {
        return this.bcSslSession;
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
    }

    @Override
    public void startHandshake() throws IOException {
    }

    @Override
    public void setUseClientMode(boolean mode) {
    }

    @Override
    public boolean getUseClientMode() {
        return false;
    }

    @Override
    public void setNeedClientAuth(boolean need) {
    }

    @Override
    public boolean getNeedClientAuth() {
        return false;
    }

    @Override
    public void setWantClientAuth(boolean want) {
    }

    @Override
    public boolean getWantClientAuth() {
        return false;
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
    }

    @Override
    public boolean getEnableSessionCreation() {
        return false;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        if (this.autoClose) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

