/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.smssender.advert2you;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import si.nevensrok.common.restclient.RestClient;
import si.nevensrok.common.restclient.RestRequest;
import si.nevensrok.common.restclient.RestResponse;
import si.nevensrok.common.smssender.BackgroundSmsSender;
import si.nevensrok.common.smssender.SmsMessage;
import si.nevensrok.common.smssender.SmsMessageResponse;
import si.nevensrok.common.utils.StringUtil;

public class Advert2YouSmsSender
extends BackgroundSmsSender
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(Advert2YouSmsSender.class);
    public static final int ERRORCODE_INVALIDAUTH = 1;
    public static final int ERRORCODE_MESSAGETOOLONG = 2;
    public static final int ERRORCODE_INVALIDSENDER = 3;
    public static final int ERRORCODE_INVALIDRECIPIENT = 4;
    public static final int ERRORCODE_SERVERERROR = 5;
    public static final int ERRORCODE_INSUFFICIENTFUNDS = 6;
    public static final int ERRORCODE_SENDERNOTREGISTRED = 7;
    public static final int ERRORCODE_INVALIDXML = 8;
    public static final int ERRORCODE_MORETHAT50MESSAGESINPACKAGE = 9;
    private String address = "http://api.advert2you.com/SendPackage.aspx";
    private String username;
    private String password;
    private String encoderCharset = "ASCII";
    private RestClient restClient = new RestClient();

    public void setConnectTimeout(int connectTimeout) {
        this.restClient.setConnectTimeout(connectTimeout);
    }

    public void setReadTimeout(int readTimeout) {
        this.restClient.setReadTimeout(readTimeout);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEncoderCharset() {
        return this.encoderCharset;
    }

    public void setEncoderCharset(String encoderCharset) {
        this.encoderCharset = encoderCharset;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        LOGGER.debug("Initializing advert2you sms message sender");
        if (StringUtil.isEmpty((String)this.username)) {
            throw new IllegalArgumentException("Property 'username' is required");
        }
        if (StringUtil.isEmpty((String)this.password)) {
            throw new IllegalArgumentException("Property 'password' is required");
        }
        super.afterPropertiesSet();
    }

    @Override
    public SmsMessageResponse sendSmsMessage(SmsMessage smsMessage) {
        RestRequest restRequest = RestRequest.post(this.getAddress());
        restRequest.setContentType("text/xml; charset=utf-8");
        restRequest.addQueryParameter("sUserName", this.getUsername());
        restRequest.addQueryParameter("sPassword", this.getPassword());
        try {
            Document responseDocument;
            Element responsePackageElement;
            NodeList smsIdNodeList;
            SmsMessageResponse response = new SmsMessageResponse();
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element packageElement = document.createElement("package");
            document.appendChild(packageElement);
            Element messageElement = document.createElement("message");
            packageElement.appendChild(messageElement);
            Element senderElement = document.createElement("sender");
            senderElement.setTextContent(smsMessage.getFrom());
            messageElement.appendChild(senderElement);
            Element receiverElement = document.createElement("receiver");
            receiverElement.setTextContent(smsMessage.getTo());
            messageElement.appendChild(receiverElement);
            Element messageContentElement = document.createElement("message");
            messageContentElement.setTextContent(smsMessage.getMessageText());
            messageElement.appendChild(messageContentElement);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
            OutputFormat outputFormat = new OutputFormat("XML", "UTF-8", false);
            XMLSerializer serializer = new XMLSerializer(buffer, outputFormat);
            serializer.asDOMSerializer();
            serializer.serialize(document.getDocumentElement());
            restRequest.setBody(buffer.toByteArray());
            RestResponse restResponse = this.restClient.execute(restRequest);
            if (!restResponse.isSuccessful()) {
                LOGGER.error("Invalid HTTP response code: {}", (Object)restResponse.getResponseCode());
            }
            if ((smsIdNodeList = (responsePackageElement = (responseDocument = docBuilder.parse(new ByteArrayInputStream(restResponse.getBody()))).getDocumentElement()).getElementsByTagName("smsid")).getLength() > 0) {
                for (int i = 0; i < smsIdNodeList.getLength(); ++i) {
                    Node smsIdNode = smsIdNodeList.item(i);
                    if (smsIdNode.getNodeType() != 1) continue;
                    String smsId = smsIdNode.getTextContent();
                    response.setSuccess(true);
                    response.setSmsId(smsId);
                    break;
                }
            } else {
                response.setSuccess(false);
                response.setErrorCode(responsePackageElement.getTextContent());
                response.setErrorMessage("Sms not send. Check error code.");
                LOGGER.error("Returned error code: {}", (Object)responsePackageElement.getTextContent());
            }
            return response;
        }
        catch (Exception e) {
            LOGGER.error("Error sending sms message", (Throwable)e);
            return new SmsMessageResponse(false, null, null, "General exception");
        }
    }
}

