/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.qrcode.codes;

import java.io.Serializable;
import si.nevensrok.common.qrcode.QRCode;
import si.nevensrok.common.qrcode.QRCodeException;
import si.nevensrok.common.qrcode.QRCodeType;

public class QRGpsCode
implements QRCode,
Serializable {
    private static final long serialVersionUID = -3702787628789078694L;
    private double latitude;
    private double longitude;

    public QRGpsCode() {
    }

    public QRGpsCode(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    @Override
    public String getCodeText() {
        return "geo:" + String.valueOf(this.latitude) + "," + String.valueOf(this.longitude);
    }

    @Override
    public QRCodeType getType() {
        return QRCodeType.GPS;
    }

    @Override
    public void parseCode(String text) throws QRCodeException {
        try {
            if (!text.startsWith("geo:")) {
                throw new QRCodeException("Not a GPS QR code!");
            }
            text = text.substring(4, text.length());
            String[] temp = text.split(",");
            this.latitude = Double.parseDouble(temp[0]);
            this.longitude = Double.parseDouble(temp[1]);
        }
        catch (QRCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QRCodeException("Error while parsing QR code", e);
        }
    }

    public String toString() {
        return "QRGpsCode [latitude=" + this.latitude + ", longitude=" + this.longitude + "]";
    }
}

