/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.jms.JmsMessageSender;
import si.nevensrok.common.jms.MessageCreator;
import si.nevensrok.common.jms.SourceType;

public class JmsMessageSenderImpl
implements JmsMessageSender,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(JmsMessageSenderImpl.class);
    private ConnectionFactory connectionFactory;
    private String destination;
    private SourceType destinationType = SourceType.QUEUE;
    private int deliveryMode = 1;
    private int priority = -1;
    private int timeToLive = -1;
    private boolean transacted = false;
    private Connection connection;
    private Session session;
    private MessageProducer messageProducer;

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public SourceType getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(SourceType destinationType) {
        this.destinationType = destinationType;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public void afterPropertiesSet() throws Exception {
        Queue jmsDestination;
        log.debug("Initializing message sender");
        if (this.getConnectionFactory() == null) {
            throw new IllegalArgumentException("Property 'connectionFactory' is required");
        }
        if (this.getDestination() == null) {
            throw new IllegalArgumentException("Property 'destination' is required");
        }
        if (this.getDestinationType() == null) {
            throw new IllegalArgumentException("Property 'destinationType' is required");
        }
        this.connection = this.getConnectionFactory().createConnection();
        this.connection.start();
        this.session = this.connection.createSession(this.isTransacted(), 1);
        if (this.getDestinationType() == SourceType.QUEUE) {
            jmsDestination = this.session.createQueue(this.getDestination());
        } else if (this.getDestinationType() == SourceType.TOPIC) {
            jmsDestination = this.session.createTopic(this.getDestination());
        } else {
            throw new IllegalArgumentException("Unsupported destination type " + (Object)((Object)this.getDestinationType()));
        }
        this.messageProducer = this.session.createProducer((Destination)jmsDestination);
        this.messageProducer.setDeliveryMode(this.getDeliveryMode());
        if (this.getPriority() > 0) {
            this.messageProducer.setPriority(this.getPriority());
        }
        if (this.getTimeToLive() > 0) {
            this.messageProducer.setTimeToLive((long)this.getTimeToLive());
        }
    }

    public void destroy() throws Exception {
        try {
            this.messageProducer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void send(MessageCreator messageCreator) throws JMSException {
        Message message = messageCreator.createMessage(this.session);
        this.messageProducer.send(message);
    }
}

