/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.convertor;

import java.io.File;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.convertor.FfmpegMediaConvertorJob;
import si.nevensrok.common.convertor.MediaConvertor;
import si.nevensrok.common.convertor.MediaConvertorJob;

public class FfmpegConvertor
implements MediaConvertor {
    private static final Logger log = LoggerFactory.getLogger(FfmpegConvertor.class);
    private String ffmpegBin = "/usr/bin/ffmpeg";
    private FileFormat fileFormat = FileFormat.mp4;
    private AudioCodec audioCodec = AudioCodec.libmp3lame;
    private Integer audioQualityScale = 5;
    private String audioBitRate = null;
    private VideoCodec videoCodec = VideoCodec.libx264;
    private Integer videoQualityScale = 7;
    private Integer videoWidth = null;
    private Integer videoHeight = null;
    private String videoBitRate = null;

    public void setFfmpegBin(String ffmpegBin) {
        this.ffmpegBin = ffmpegBin;
    }

    public void setAudioQualityScale(Integer audioQualityScale) {
        this.audioQualityScale = audioQualityScale;
    }

    public void setAudioBitRate(String audioBitRate) {
        this.audioBitRate = audioBitRate;
    }

    public void setVideoQualityScale(Integer videoQualityScale) {
        this.videoQualityScale = videoQualityScale;
    }

    public void setVideoWidth(Integer videoWidth) {
        this.videoWidth = videoWidth;
    }

    public void setVideoHeight(Integer videoHeight) {
        this.videoHeight = videoHeight;
    }

    public void setVideoBitRate(String videoBitRate) {
        this.videoBitRate = videoBitRate;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
        if (fileFormat == FileFormat.mp4) {
            this.audioCodec = AudioCodec.libmp3lame;
            this.videoCodec = VideoCodec.libx264;
        } else if (fileFormat == FileFormat.ogg) {
            this.audioCodec = AudioCodec.libvorbis;
            this.videoCodec = VideoCodec.libtheora;
        }
    }

    @Override
    public MediaConvertorJob convertFile(File inputFile, File outputFile) {
        try {
            LinkedList<String> cmdArray = new LinkedList<String>();
            cmdArray.add(this.ffmpegBin);
            cmdArray.add("-y");
            cmdArray.add("-i");
            cmdArray.add(inputFile.getAbsolutePath());
            cmdArray.add("-codec:v");
            cmdArray.add(this.videoCodec.name());
            cmdArray.add("-qscale:v");
            cmdArray.add(this.videoQualityScale.toString());
            if (this.videoBitRate != null) {
                cmdArray.add("-b:v");
                cmdArray.add(this.videoBitRate);
            }
            if (this.videoWidth != null && this.videoHeight != null) {
                cmdArray.add("-vf");
                cmdArray.add("scale=" + this.videoWidth.toString() + ":" + this.videoHeight.toString());
            }
            cmdArray.add("-codec:a");
            cmdArray.add(this.audioCodec.name());
            cmdArray.add("-qscale:a");
            cmdArray.add(this.audioQualityScale.toString());
            if (this.audioBitRate != null) {
                cmdArray.add("-b:a");
                cmdArray.add(this.audioBitRate);
            }
            cmdArray.add("-f");
            cmdArray.add(this.fileFormat.name());
            cmdArray.add(outputFile.getAbsolutePath());
            Process process = Runtime.getRuntime().exec(cmdArray.toArray(new String[0]));
            return new FfmpegMediaConvertorJob(process);
        }
        catch (Exception e) {
            log.error("Error starting media convertor job", (Throwable)e);
            return null;
        }
    }

    public static enum AudioCodec {
        libvorbis,
        libmp3lame;

    }

    public static enum VideoCodec {
        libtheora,
        libx264;

    }

    public static enum FileFormat {
        ogg,
        mp4;

    }
}

