/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.buffer;

public class WriteByteBuffer {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private byte[] buffer;
    private int length = 0;
    private int maxSize = Integer.MAX_VALUE;

    public WriteByteBuffer() {
        this(4096);
    }

    public WriteByteBuffer(int initialSize) {
        this.buffer = new byte[initialSize];
    }

    public WriteByteBuffer(int initialSize, int maxSize) {
        this(initialSize);
        this.maxSize = maxSize;
    }

    public synchronized void clear() {
        this.length = 0;
    }

    public synchronized void add(byte b) {
        if (this.length >= this.buffer.length) {
            if (this.buffer.length >= this.maxSize) {
                throw new IllegalStateException("Maximum buffer size reached");
            }
            byte[] newBuffer = new byte[Math.min(Math.max(4096, this.buffer.length * 2), this.maxSize)];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.length);
            this.buffer = newBuffer;
        }
        this.buffer[this.length++] = b;
    }

    public synchronized void add(byte[] bytes) {
        this.add(bytes, 0, bytes.length);
    }

    public synchronized void add(byte[] bytes, int offset, int length) {
        int neededLength = this.length + length;
        if (neededLength > this.buffer.length) {
            if (neededLength >= this.maxSize) {
                throw new IllegalStateException("Not enough space available in buffer");
            }
            byte[] newBuffer = new byte[Math.min(Math.max(Math.max(4096, this.buffer.length * 2), neededLength), this.maxSize)];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.length);
            this.buffer = newBuffer;
        }
        System.arraycopy(bytes, offset, this.buffer, this.length, length);
        this.length += length;
    }

    public synchronized void add(WriteByteBuffer byteBuffer) {
        this.add(byteBuffer.getBuffer(), 0, byteBuffer.getLength());
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getLength() {
        return this.length;
    }

    public int getCurrentBufferSize() {
        return this.buffer.length;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public synchronized byte[] getByteArray() {
        if (this.length == this.buffer.length) {
            return this.buffer;
        }
        byte[] data = new byte[this.length];
        System.arraycopy(this.buffer, 0, data, 0, this.length);
        return data;
    }

    public boolean isBufferFull() {
        return this.length >= this.maxSize;
    }

    public int getAvailableCapacity() {
        return this.maxSize - this.length;
    }
}

