/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import javafx.beans.NamedArg;
import javafx.geometry.Insets;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeType;

public class BorderStroke {
    public static final BorderWidths THIN = new BorderWidths(1.0);
    public static final BorderWidths MEDIUM = new BorderWidths(3.0);
    public static final BorderWidths THICK = new BorderWidths(5.0);
    public static final BorderWidths DEFAULT_WIDTHS = THIN;
    final Paint topStroke;
    final Paint rightStroke;
    final Paint bottomStroke;
    final Paint leftStroke;
    final BorderStrokeStyle topStyle;
    final BorderStrokeStyle rightStyle;
    final BorderStrokeStyle bottomStyle;
    final BorderStrokeStyle leftStyle;
    final BorderWidths widths;
    final Insets insets;
    final Insets innerEdge;
    final Insets outerEdge;
    private final CornerRadii radii;
    private final boolean strokeUniform;
    private final int hash;

    public final Paint getTopStroke() {
        return this.topStroke;
    }

    public final Paint getRightStroke() {
        return this.rightStroke;
    }

    public final Paint getBottomStroke() {
        return this.bottomStroke;
    }

    public final Paint getLeftStroke() {
        return this.leftStroke;
    }

    public final BorderStrokeStyle getTopStyle() {
        return this.topStyle;
    }

    public final BorderStrokeStyle getRightStyle() {
        return this.rightStyle;
    }

    public final BorderStrokeStyle getBottomStyle() {
        return this.bottomStyle;
    }

    public final BorderStrokeStyle getLeftStyle() {
        return this.leftStyle;
    }

    public final BorderWidths getWidths() {
        return this.widths;
    }

    public final Insets getInsets() {
        return this.insets;
    }

    public final CornerRadii getRadii() {
        return this.radii;
    }

    public final boolean isStrokeUniform() {
        return this.strokeUniform;
    }

    public BorderStroke(@NamedArg(value="stroke") Paint stroke, @NamedArg(value="style") BorderStrokeStyle style, @NamedArg(value="radii") CornerRadii radii, @NamedArg(value="widths") BorderWidths widths) {
        this.bottomStroke = stroke == null ? Color.BLACK : stroke;
        this.rightStroke = this.bottomStroke;
        this.topStroke = this.bottomStroke;
        this.leftStroke = this.bottomStroke;
        this.leftStyle = style == null ? BorderStrokeStyle.NONE : style;
        this.bottomStyle = this.leftStyle;
        this.rightStyle = this.leftStyle;
        this.topStyle = this.leftStyle;
        this.radii = radii == null ? CornerRadii.EMPTY : radii;
        this.widths = widths == null ? DEFAULT_WIDTHS : widths;
        this.insets = Insets.EMPTY;
        this.strokeUniform = this.widths.left == this.widths.top && this.widths.left == this.widths.right && this.widths.left == this.widths.bottom;
        this.innerEdge = new Insets(this.computeInside(this.topStyle.getType(), this.widths.getTop()), this.computeInside(this.rightStyle.getType(), this.widths.getRight()), this.computeInside(this.bottomStyle.getType(), this.widths.getBottom()), this.computeInside(this.leftStyle.getType(), this.widths.getLeft()));
        this.outerEdge = new Insets(Math.max(0.0, this.computeOutside(this.topStyle.getType(), this.widths.getTop())), Math.max(0.0, this.computeOutside(this.rightStyle.getType(), this.widths.getRight())), Math.max(0.0, this.computeOutside(this.bottomStyle.getType(), this.widths.getBottom())), Math.max(0.0, this.computeOutside(this.leftStyle.getType(), this.widths.getLeft())));
        this.hash = this.preComputeHash();
    }

    public BorderStroke(@NamedArg(value="stroke") Paint stroke, @NamedArg(value="style") BorderStrokeStyle style, @NamedArg(value="radii") CornerRadii radii, @NamedArg(value="widths") BorderWidths widths, @NamedArg(value="insets") Insets insets) {
        this(stroke, stroke, stroke, stroke, style, style, style, style, radii, widths, insets);
    }

    public BorderStroke(@NamedArg(value="topStroke") Paint topStroke, @NamedArg(value="rightStroke") Paint rightStroke, @NamedArg(value="bottomStroke") Paint bottomStroke, @NamedArg(value="leftStroke") Paint leftStroke, @NamedArg(value="topStyle") BorderStrokeStyle topStyle, @NamedArg(value="rightStyle") BorderStrokeStyle rightStyle, @NamedArg(value="bottomStyle") BorderStrokeStyle bottomStyle, @NamedArg(value="leftStyle") BorderStrokeStyle leftStyle, @NamedArg(value="radii") CornerRadii radii, @NamedArg(value="widths") BorderWidths widths, @NamedArg(value="insets") Insets insets) {
        this.topStroke = topStroke == null ? Color.BLACK : topStroke;
        this.rightStroke = rightStroke == null ? this.topStroke : rightStroke;
        this.bottomStroke = bottomStroke == null ? this.topStroke : bottomStroke;
        this.leftStroke = leftStroke == null ? this.rightStroke : leftStroke;
        this.topStyle = topStyle == null ? BorderStrokeStyle.NONE : topStyle;
        this.rightStyle = rightStyle == null ? this.topStyle : rightStyle;
        this.bottomStyle = bottomStyle == null ? this.topStyle : bottomStyle;
        this.leftStyle = leftStyle == null ? this.rightStyle : leftStyle;
        this.radii = radii == null ? CornerRadii.EMPTY : radii;
        this.widths = widths == null ? DEFAULT_WIDTHS : widths;
        this.insets = insets == null ? Insets.EMPTY : insets;
        boolean colorsSame = this.leftStroke.equals(this.topStroke) && this.leftStroke.equals(this.rightStroke) && this.leftStroke.equals(this.bottomStroke);
        boolean widthsSame = this.widths.left == this.widths.top && this.widths.left == this.widths.right && this.widths.left == this.widths.bottom;
        boolean stylesSame = this.leftStyle.equals(this.topStyle) && this.leftStyle.equals(this.rightStyle) && this.leftStyle.equals(this.bottomStyle);
        this.strokeUniform = colorsSame && widthsSame && stylesSame;
        this.innerEdge = new Insets(this.insets.getTop() + this.computeInside(this.topStyle.getType(), this.widths.getTop()), this.insets.getRight() + this.computeInside(this.rightStyle.getType(), this.widths.getRight()), this.insets.getBottom() + this.computeInside(this.bottomStyle.getType(), this.widths.getBottom()), this.insets.getLeft() + this.computeInside(this.leftStyle.getType(), this.widths.getLeft()));
        this.outerEdge = new Insets(Math.max(0.0, this.computeOutside(this.topStyle.getType(), this.widths.getTop()) - this.insets.getTop()), Math.max(0.0, this.computeOutside(this.rightStyle.getType(), this.widths.getRight()) - this.insets.getRight()), Math.max(0.0, this.computeOutside(this.bottomStyle.getType(), this.widths.getBottom()) - this.insets.getBottom()), Math.max(0.0, this.computeOutside(this.leftStyle.getType(), this.widths.getLeft()) - this.insets.getLeft()));
        this.hash = this.preComputeHash();
    }

    private int preComputeHash() {
        int result = this.topStroke.hashCode();
        result = 31 * result + this.rightStroke.hashCode();
        result = 31 * result + this.bottomStroke.hashCode();
        result = 31 * result + this.leftStroke.hashCode();
        result = 31 * result + this.topStyle.hashCode();
        result = 31 * result + this.rightStyle.hashCode();
        result = 31 * result + this.bottomStyle.hashCode();
        result = 31 * result + this.leftStyle.hashCode();
        result = 31 * result + this.widths.hashCode();
        result = 31 * result + this.radii.hashCode();
        result = 31 * result + this.insets.hashCode();
        return result;
    }

    private double computeInside(StrokeType type, double width) {
        if (type == StrokeType.OUTSIDE) {
            return 0.0;
        }
        if (type == StrokeType.CENTERED) {
            return width / 2.0;
        }
        if (type == StrokeType.INSIDE) {
            return width;
        }
        throw new AssertionError((Object)"Unexpected Stroke Type");
    }

    private double computeOutside(StrokeType type, double width) {
        if (type == StrokeType.OUTSIDE) {
            return width;
        }
        if (type == StrokeType.CENTERED) {
            return width / 2.0;
        }
        if (type == StrokeType.INSIDE) {
            return 0.0;
        }
        throw new AssertionError((Object)"Unexpected Stroke Type");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BorderStroke that = (BorderStroke)o;
        if (this.hash != that.hash) {
            return false;
        }
        if (!this.bottomStroke.equals(that.bottomStroke)) {
            return false;
        }
        if (!this.bottomStyle.equals(that.bottomStyle)) {
            return false;
        }
        if (!this.leftStroke.equals(that.leftStroke)) {
            return false;
        }
        if (!this.leftStyle.equals(that.leftStyle)) {
            return false;
        }
        if (!this.radii.equals(that.radii)) {
            return false;
        }
        if (!this.rightStroke.equals(that.rightStroke)) {
            return false;
        }
        if (!this.rightStyle.equals(that.rightStyle)) {
            return false;
        }
        if (!this.topStroke.equals(that.topStroke)) {
            return false;
        }
        if (!this.topStyle.equals(that.topStyle)) {
            return false;
        }
        if (!this.widths.equals(that.widths)) {
            return false;
        }
        return this.insets.equals(that.insets);
    }

    public int hashCode() {
        return this.hash;
    }
}

