/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public abstract class CellBehaviorBase<T extends Cell>
extends BehaviorBase<T> {
    private static final String ANCHOR_PROPERTY_KEY = "anchor";
    private static final String IS_DEFAULT_ANCHOR_KEY = "isDefaultAnchor";
    private boolean latePress = false;

    public static <T> T getAnchor(Control control, T defaultResponse) {
        return (T)(CellBehaviorBase.hasNonDefaultAnchor(control) ? control.getProperties().get(ANCHOR_PROPERTY_KEY) : defaultResponse);
    }

    public static <T> void setAnchor(Control control, T anchor, boolean isDefaultAnchor) {
        if (control != null && anchor == null) {
            CellBehaviorBase.removeAnchor(control);
        } else {
            control.getProperties().put(ANCHOR_PROPERTY_KEY, anchor);
            control.getProperties().put(IS_DEFAULT_ANCHOR_KEY, isDefaultAnchor);
        }
    }

    public static boolean hasNonDefaultAnchor(Control control) {
        Boolean isDefaultAnchor = (Boolean)control.getProperties().remove(IS_DEFAULT_ANCHOR_KEY);
        return (isDefaultAnchor == null || isDefaultAnchor == false) && CellBehaviorBase.hasAnchor(control);
    }

    public static boolean hasDefaultAnchor(Control control) {
        Boolean isDefaultAnchor = (Boolean)control.getProperties().remove(IS_DEFAULT_ANCHOR_KEY);
        return isDefaultAnchor != null && isDefaultAnchor == true && CellBehaviorBase.hasAnchor(control);
    }

    private static boolean hasAnchor(Control control) {
        return control.getProperties().get(ANCHOR_PROPERTY_KEY) != null;
    }

    public static void removeAnchor(Control control) {
        control.getProperties().remove(ANCHOR_PROPERTY_KEY);
        control.getProperties().remove(IS_DEFAULT_ANCHOR_KEY);
    }

    public CellBehaviorBase(T control, List<KeyBinding> bindings) {
        super(control, bindings);
    }

    protected abstract Control getCellContainer();

    protected abstract MultipleSelectionModel<?> getSelectionModel();

    protected abstract FocusModel<?> getFocusModel();

    protected abstract void edit(T var1);

    protected boolean handleDisclosureNode(double x, double y) {
        return false;
    }

    protected boolean isClickPositionValid(double x, double y) {
        return true;
    }

    protected int getIndex() {
        return this.getControl() instanceof IndexedCell ? ((IndexedCell)this.getControl()).getIndex() : -1;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isSynthesized()) {
            this.latePress = true;
        } else {
            this.latePress = this.isSelected();
            if (!this.latePress) {
                this.doSelect(e.getX(), e.getY(), e.getButton(), e.getClickCount(), e.isShiftDown(), e.isShortcutDown());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.latePress) {
            this.latePress = false;
            this.doSelect(e.getX(), e.getY(), e.getButton(), e.getClickCount(), e.isShiftDown(), e.isShortcutDown());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.latePress = false;
    }

    protected void doSelect(double x, double y, MouseButton button, int clickCount, boolean shiftDown, boolean shortcutDown) {
        Cell cell = (Cell)this.getControl();
        Control cellContainer = this.getCellContainer();
        if (cell.isEmpty() || !cell.contains(x, y)) {
            return;
        }
        int index = this.getIndex();
        boolean selected = cell.isSelected();
        MultipleSelectionModel<?> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        FocusModel<?> fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        if (this.handleDisclosureNode(x, y)) {
            return;
        }
        if (!this.isClickPositionValid(x, y)) {
            return;
        }
        if (shiftDown) {
            if (!CellBehaviorBase.hasNonDefaultAnchor(cellContainer)) {
                CellBehaviorBase.setAnchor(cellContainer, fm.getFocusedIndex(), false);
            }
        } else {
            CellBehaviorBase.removeAnchor(cellContainer);
        }
        if (button == MouseButton.PRIMARY || button == MouseButton.SECONDARY && !selected) {
            if (sm.getSelectionMode() == SelectionMode.SINGLE) {
                this.simpleSelect(button, clickCount, shortcutDown);
            } else if (shortcutDown) {
                if (selected) {
                    sm.clearSelection(index);
                    fm.focus(index);
                } else {
                    sm.select(index);
                }
            } else if (shiftDown && clickCount == 1) {
                int focusedIndex = CellBehaviorBase.getAnchor(cellContainer, fm.getFocusedIndex());
                this.selectRows(focusedIndex, index);
                fm.focus(index);
            } else {
                this.simpleSelect(button, clickCount, shortcutDown);
            }
        }
    }

    protected void simpleSelect(MouseButton button, int clickCount, boolean shortcutDown) {
        int index = this.getIndex();
        MultipleSelectionModel<?> sm = this.getSelectionModel();
        boolean isAlreadySelected = sm.isSelected(index);
        if (isAlreadySelected && shortcutDown) {
            sm.clearSelection(index);
            this.getFocusModel().focus(index);
            isAlreadySelected = false;
        } else {
            sm.clearAndSelect(index);
        }
        this.handleClicks(button, clickCount, isAlreadySelected);
    }

    protected void handleClicks(MouseButton button, int clickCount, boolean isAlreadySelected) {
        if (button == MouseButton.PRIMARY) {
            if (clickCount == 1 && isAlreadySelected) {
                this.edit((Cell)this.getControl());
            } else if (clickCount == 1) {
                this.edit(null);
            } else if (clickCount == 2 && ((Cell)this.getControl()).isEditable()) {
                this.edit((Cell)this.getControl());
            }
        }
    }

    void selectRows(int focusedIndex, int index) {
        boolean asc = focusedIndex < index;
        int minRow = Math.min(focusedIndex, index);
        int maxRow = Math.max(focusedIndex, index);
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>(this.getSelectionModel().getSelectedIndices());
        int max = selectedIndices.size();
        for (int i = 0; i < max; ++i) {
            int selectedIndex = (Integer)selectedIndices.get(i);
            if (selectedIndex >= minRow && selectedIndex <= maxRow) continue;
            this.getSelectionModel().clearSelection(selectedIndex);
        }
        if (minRow == maxRow) {
            this.getSelectionModel().select(minRow);
        } else if (asc) {
            this.getSelectionModel().selectRange(minRow, maxRow + 1);
        } else {
            this.getSelectionModel().selectRange(maxRow, minRow - 1);
        }
    }

    protected boolean isSelected() {
        return ((Cell)this.getControl()).isSelected();
    }
}

