/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.x509cert;

import java.math.BigInteger;
import java.security.KeyPair;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Random;
import si.nevensrok.common.x509cert.CertificateData;
import si.nevensrok.common.x509cert.SigningAlgorithm;
import sun.security.x509.AlgorithmId;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.DNSName;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class CertificateGenerator {
    private static final Random random = new Random();
    private CertificateData certificateData;
    private String[] domainNames;
    private Date validFrom;
    private Date validUntil;
    private BigInteger serialNumber;
    private Boolean isUsedForSigning = Boolean.FALSE;
    private Boolean isCa = Boolean.FALSE;
    private int certificationPathLength = -1;
    private KeyPair keyPair;
    private SigningAlgorithm signingAlgorithm = SigningAlgorithm.SHA256withRSA;
    private CertificateData issuerCertificateData;
    private KeyPair issuerKeyPair;

    public CertificateGenerator withCertificateData(CertificateData certificateData) {
        this.certificateData = certificateData;
        return this;
    }

    public CertificateGenerator withDomainNames(String ... domainNames) {
        this.domainNames = domainNames;
        return this;
    }

    public CertificateGenerator withDomainNames(Collection<String> domainNames) {
        this.domainNames = domainNames.toArray(new String[domainNames.size()]);
        return this;
    }

    public CertificateGenerator withValidPeriod(Date validFrom, Date validUntil) {
        this.validFrom = validFrom;
        this.validUntil = validUntil;
        return this;
    }

    public CertificateGenerator withValidPeriod(Calendar validFrom, Calendar validUntil) {
        this.validFrom = validFrom.getTime();
        this.validUntil = validUntil.getTime();
        return this;
    }

    public CertificateGenerator withSerialNumber(BigInteger serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public CertificateGenerator withIsUsedForSigning(Boolean isUsedForSigning) {
        this.isUsedForSigning = isUsedForSigning;
        return this;
    }

    public CertificateGenerator withIsCa(Boolean isCa) {
        this.isCa = isCa;
        return this;
    }

    public CertificateGenerator withIsCa(Boolean isCa, int certificationPathLength) {
        this.isCa = isCa;
        this.certificationPathLength = certificationPathLength;
        return this;
    }

    public CertificateGenerator withKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public CertificateGenerator withSigningAlgorithm(SigningAlgorithm signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
        return this;
    }

    public CertificateGenerator withIssuerCertificateData(CertificateData issuerCertificateData) {
        this.issuerCertificateData = issuerCertificateData;
        return this;
    }

    public CertificateGenerator withIssuerKeyPair(KeyPair issuerKeyPair) {
        this.issuerKeyPair = issuerKeyPair;
        return this;
    }

    public X509CertImpl generate() {
        try {
            if (this.certificateData == null) {
                throw new IllegalArgumentException("CertificateData is not set");
            }
            if (this.validFrom == null) {
                throw new IllegalArgumentException("ValidFrom is not set");
            }
            if (this.validUntil == null) {
                throw new IllegalArgumentException("ValidUntil is not set");
            }
            if (this.keyPair == null) {
                throw new IllegalArgumentException("KeyPair is not set");
            }
            if (this.signingAlgorithm == null) {
                throw new IllegalArgumentException("SigningAlgorithm is not set");
            }
            X500Name name = new X500Name(this.certificateData.getCommonName(), this.certificateData.getOrganizationUnit(), this.certificateData.getOrganization(), this.certificateData.getCity(), this.certificateData.getState(), this.certificateData.getCountry());
            CertificateValidity validity = new CertificateValidity(this.validFrom, this.validUntil);
            CertificateExtensions someExtensions = new CertificateExtensions();
            if (this.isUsedForSigning != null && this.isUsedForSigning.booleanValue()) {
                KeyUsageExtension keyUsageExtension = new KeyUsageExtension();
                keyUsageExtension.set("key_certsign", Boolean.TRUE);
                someExtensions.set("KeyUsage", keyUsageExtension);
                if (this.isCa != null && this.isCa.booleanValue()) {
                    BasicConstraintsExtension basicConstraintsExtension = new BasicConstraintsExtension(true, this.certificationPathLength);
                    someExtensions.set("BasicConstraints", basicConstraintsExtension);
                }
            }
            X509CertInfo certInfo = new X509CertInfo();
            certInfo.set("version", new CertificateVersion(2));
            if (this.serialNumber == null) {
                byte[] randomBytes = new byte[20];
                random.nextBytes(randomBytes);
                String[] serialNumber = new BigInteger(randomBytes);
                certInfo.set("serialNumber", new CertificateSerialNumber(serialNumber.abs()));
            } else {
                certInfo.set("serialNumber", new CertificateSerialNumber(this.serialNumber));
            }
            certInfo.set("subject", name);
            certInfo.set("key", new CertificateX509Key(this.keyPair.getPublic()));
            certInfo.set("validity", validity);
            certInfo.set("extensions", someExtensions);
            if (this.domainNames != null && this.domainNames.length > 0) {
                GeneralNames generalNames = new GeneralNames();
                for (String domainName : this.domainNames) {
                    GeneralName generalName = new GeneralName(new DNSName(domainName));
                    generalNames.add(generalName);
                }
                SubjectAlternativeNameExtension subjectAlternativeNameExtension = new SubjectAlternativeNameExtension();
                subjectAlternativeNameExtension.set("subject_name", generalNames);
                someExtensions.set("SubjectAlternativeName", subjectAlternativeNameExtension);
            }
            if (this.issuerCertificateData != null && this.issuerKeyPair != null) {
                X500Name issuerName = new X500Name(this.issuerCertificateData.getCommonName(), this.issuerCertificateData.getOrganizationUnit(), this.issuerCertificateData.getOrganization(), this.issuerCertificateData.getCity(), this.issuerCertificateData.getState(), this.issuerCertificateData.getCountry());
                certInfo.set("algorithmID", new CertificateAlgorithmId(AlgorithmId.get(this.signingAlgorithm.getValue())));
                certInfo.set("issuer", issuerName);
            } else {
                certInfo.set("algorithmID", new CertificateAlgorithmId(AlgorithmId.get(this.signingAlgorithm.getValue())));
                certInfo.set("issuer", name);
            }
            X509CertImpl certificate = new X509CertImpl(certInfo);
            if (this.issuerCertificateData != null && this.issuerKeyPair != null) {
                certificate.sign(this.issuerKeyPair.getPrivate(), this.signingAlgorithm.getValue());
                certificate.verify(this.issuerKeyPair.getPublic());
            } else {
                certificate.sign(this.keyPair.getPrivate(), this.signingAlgorithm.getValue());
                certificate.verify(this.keyPair.getPublic());
            }
            return certificate;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating certificate", e);
        }
    }
}

