/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.textrenderer.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.freemarker.ClasspathTemplateLoader;
import si.nevensrok.common.textrenderer.AbstractTextRenderer;
import si.nevensrok.common.textrenderer.TextRenderException;
import si.nevensrok.common.textrenderer.TextRenderer;
import si.nevensrok.common.textrenderer.freemarker.ContextData;

public class FreeMarkerTextRenderer
extends AbstractTextRenderer
implements TextRenderer,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(FreeMarkerTextRenderer.class);
    private Configuration configuration;
    private Map<String, Object> toolbox;
    private TemplateLoader templateLoader;
    private Map<String, String> autoImports;

    public Map<String, Object> getToolbox() {
        return this.toolbox;
    }

    public void setToolbox(Map<String, Object> toolbox) {
        this.toolbox = toolbox;
    }

    public TemplateLoader getTemplateLoader() {
        return this.templateLoader;
    }

    public void setTemplateLoader(TemplateLoader templateLoader) {
        this.templateLoader = templateLoader;
    }

    public Map<String, String> getAutoImports() {
        return this.autoImports;
    }

    public void setAutoImports(Map<String, String> autoImports) {
        this.autoImports = autoImports;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.templateLoader == null) {
            this.templateLoader = new ClasspathTemplateLoader();
        }
        if (this.autoImports == null) {
            this.autoImports = new LinkedHashMap<String, String>();
            this.autoImports.put("spring", "/si/nevensrok/common/textrenderer/freemarker/springMessage.ftl");
        }
        this.configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        for (Map.Entry<String, String> entry : this.getAutoImports().entrySet()) {
            this.configuration.addAutoImport(entry.getKey(), entry.getValue());
        }
        if (this.getTemplateLoader() != null) {
            this.configuration.setTemplateLoader(this.getTemplateLoader());
        }
    }

    @Override
    public String renderText(String file, Map<String, Object> data, Locale locale) throws TextRenderException {
        Template template;
        log.debug("Using template: {}", (Object)file);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            template = this.configuration.getTemplate(file, locale);
        }
        catch (IOException e) {
            throw new TextRenderException("Error laoding template for path '" + file + "'", e);
        }
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>();
        context.putAll(data);
        ContextData contextData = new ContextData();
        contextData.setLocale(locale);
        contextData.setMessageSource(this.getMessageSource());
        context.put("contextData", contextData);
        if (this.getToolbox() != null) {
            context.putAll(this.getToolbox());
        }
        StringWriter buffer = new StringWriter();
        try {
            template.process(context, (Writer)buffer);
        }
        catch (Exception e) {
            throw new TextRenderException("Error rendering template", e);
        }
        return buffer.toString();
    }
}

