/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.jms;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import si.nevensrok.common.utils.ObjectUtil;

public class BytesMessageConverter
implements MessageConverter {
    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        if (message instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)message;
            byte[] data = new byte[(int)bytesMessage.getBodyLength()];
            bytesMessage.readBytes(data);
            Object object = ObjectUtil.deserializeObject((byte[])data);
            return object;
        }
        throw new MessageConversionException("Unsupported message type");
    }

    public Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        byte[] data = ObjectUtil.serializeObject((Object)object);
        BytesMessage bytesMessage = session.createBytesMessage();
        bytesMessage.writeBytes(data);
        bytesMessage.setStringProperty("Content-Type", "application/x-java-serialized-object");
        return bytesMessage;
    }
}

