/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.cache;

import java.lang.reflect.Method;
import java.util.LinkedList;
import org.springframework.cache.interceptor.KeyGenerator;
import si.nevensrok.common.utils.ByteUtil;
import si.nevensrok.common.utils.HashUtil;

public class HashKeyGenerator
implements KeyGenerator {
    private boolean resultAsString = true;
    private HashUtil.HashType hashType = HashUtil.HashType.SHA1;

    public void setResultAsString(boolean resultAsString) {
        this.resultAsString = resultAsString;
    }

    public void setHashType(HashUtil.HashType hashType) {
        this.hashType = hashType;
    }

    public Object generate(Object target, Method method, Object ... params) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (Object obj : params) {
            list.add(obj);
        }
        byte[] hash = HashUtil.generateHash(list, (HashUtil.HashType)this.hashType);
        if (this.resultAsString) {
            return ByteUtil.toHexString((byte[])hash);
        }
        return hash;
    }
}

