/*
 * Decompiled with CFR 0.152.
 */
package jdk.packager.services.userjvmoptions;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import jdk.packager.services.UserJvmOptionsService;

public final class PreferencesUserJvmOptions
implements UserJvmOptionsService {
    Preferences node = Preferences.userRoot().node(System.getProperty("app.preferences.id").replace(".", "/")).node("JVMUserOptions");

    @Override
    public Map<String, String> getUserJVMOptions() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        try {
            for (String s : this.node.childrenNames()) {
                String o = this.node.get(s, null);
                if (o == null) continue;
                result.put(s, o);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void setUserJVMOptions(Map<String, String> options) {
        try {
            this.node.clear();
            for (Map.Entry<String, String> entry : options.entrySet()) {
                this.node.put(entry.getKey(), entry.getValue());
            }
            this.node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    @Override
    public Map<String, String> getUserJVMOptionDefaults() {
        throw new UnsupportedOperationException("Preferences backed UserJvmOptions do not enumerate their defaults");
    }
}

