/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.utils.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.network.NetworkMessageHandler;
import si.nevensrok.common.network.QueueNetworkMessageHandler;
import si.nevensrok.common.network.udp.UdpBroadcastMessageSender;
import si.nevensrok.common.network.udp.UdpMessageReceiver;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.utils.broadcaster.FindServer;
import si.nevensrok.jtekma.utils.broadcaster.ServerInfo;

public class CredentialsDialog
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialsDialog.class);
    private static final long serialVersionUID = 733462454100373133L;
    private Map<String, String> messages = null;
    private Credentials credentials = null;
    private DefaultComboBoxModel<String> urlComboBoxModel = new DefaultComboBoxModel();
    private JComboBox<String> urlField;
    private JTextField usernameField = new JTextField();
    private JPasswordField passwordField = new JPasswordField();
    private JButton okButton = new JButton();
    private UdpMessageReceiver udpMessageReceiver = null;
    private QueueNetworkMessageHandler receiverQueue = new QueueNetworkMessageHandler();
    private UdpBroadcastMessageSender udpBroadcastMessageSender = null;

    public CredentialsDialog(Frame window, Map<String, String> messages) {
        super(window, true);
        this.messages = messages;
        this.init();
    }

    public CredentialsDialog(Dialog window, Map<String, String> messages) {
        super(window, true);
        this.messages = messages;
        this.init();
    }

    private void init() {
        this.setTitle(this.messages != null ? this.messages.get("title") : "Enter login information");
        this.setResizable(false);
        this.setSize(new Dimension(500, 210));
        this.setLayout(new BorderLayout(10, 10));
        JPanel centerPanel = new JPanel(new GridLayout(4, 1));
        this.add((Component)centerPanel, "Center");
        JPanel urlPanel = new JPanel(new FlowLayout(0, 10, 10));
        centerPanel.add(urlPanel);
        JLabel urlLabel = new JLabel(this.messages != null ? this.messages.get("url") : "Url:");
        urlLabel.setPreferredSize(new Dimension(120, 20));
        urlPanel.add(urlLabel);
        String[] urls = new String[]{};
        if (this.messages != null && this.messages.get("defaultServiceUrl") != null) {
            urls = this.messages.get("defaultServiceUrl").split("[,;]");
        }
        for (String url : urls) {
            if (url.trim().isEmpty()) continue;
            this.urlComboBoxModel.addElement(url.trim());
        }
        this.urlField = new JComboBox<String>(this.urlComboBoxModel);
        this.urlField.setEditable(true);
        this.urlField.setPreferredSize(new Dimension(320, 20));
        urlPanel.add(this.urlField);
        this.urlField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    CredentialsDialog.this.usernameField.requestFocus();
                } else if (e.getKeyCode() == 10) {
                    CredentialsDialog.this.okAction();
                }
            }
        });
        JPanel usernamePanel = new JPanel(new FlowLayout(0, 10, 10));
        centerPanel.add(usernamePanel);
        JLabel usernameLabel = new JLabel(this.messages != null ? this.messages.get("username") : "Username:");
        usernameLabel.setPreferredSize(new Dimension(120, 20));
        usernamePanel.add(usernameLabel);
        this.usernameField.setPreferredSize(new Dimension(320, 20));
        usernamePanel.add(this.usernameField);
        this.usernameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    CredentialsDialog.this.passwordField.requestFocus();
                } else if (e.getKeyCode() == 10) {
                    CredentialsDialog.this.okAction();
                }
            }
        });
        JPanel passwordPanel = new JPanel(new FlowLayout(0, 10, 10));
        centerPanel.add(passwordPanel);
        JLabel passwordLabel = new JLabel(this.messages != null ? this.messages.get("password") : "Password:");
        passwordLabel.setPreferredSize(new Dimension(120, 20));
        passwordPanel.add(passwordLabel);
        this.passwordField.setPreferredSize(new Dimension(320, 20));
        passwordPanel.add(this.passwordField);
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    CredentialsDialog.this.okButton.requestFocus();
                } else if (e.getKeyCode() == 10) {
                    CredentialsDialog.this.okAction();
                }
            }
        });
        JPanel buildVersionPanel = new JPanel(new FlowLayout(0, 10, 10));
        centerPanel.add(buildVersionPanel);
        JLabel buildVersionLabel = new JLabel(this.messages != null ? this.messages.get("buildVersion") : "Build version:");
        buildVersionLabel.setPreferredSize(new Dimension(120, 20));
        buildVersionPanel.add(buildVersionLabel);
        JLabel buildVersionDisplayLabel = new JLabel(this.messages != null ? this.messages.get("buildVersionDisplay") : "");
        buildVersionDisplayLabel.setPreferredSize(new Dimension(320, 20));
        buildVersionPanel.add(buildVersionDisplayLabel);
        JPanel buttonsPanel = new JPanel(new FlowLayout(1, 20, 10));
        this.add((Component)buttonsPanel, "South");
        this.okButton.setText(this.messages != null ? this.messages.get("login") : "Login");
        buttonsPanel.add(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CredentialsDialog.this.okAction();
            }
        });
        JButton cancelButton = new JButton(this.messages != null ? this.messages.get("cancel") : "Cancel");
        buttonsPanel.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CredentialsDialog.this.setVisible(false);
                CredentialsDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CredentialsDialog.this.setVisible(false);
                CredentialsDialog.this.dispose();
            }
        });
        if (this.messages != null && this.messages.get("broadcaster.port") != null) {
            this.udpMessageReceiver = new UdpMessageReceiver();
            this.udpMessageReceiver.setNetworkMessageHandler((NetworkMessageHandler)this.receiverQueue);
            try {
                this.udpMessageReceiver.afterPropertiesSet();
            }
            catch (Exception e) {
                LOGGER.error("Error initializing UDP message receiver", (Throwable)e);
            }
            this.udpBroadcastMessageSender = new UdpBroadcastMessageSender();
            this.udpBroadcastMessageSender.setPort(Integer.valueOf(Integer.parseInt(this.messages.get("broadcaster.port"))));
            try {
                this.udpBroadcastMessageSender.afterPropertiesSet();
            }
            catch (Exception e) {
                LOGGER.error("Error initializing UDP message sender", (Throwable)e);
            }
            try {
                FindServer findServer = new FindServer();
                findServer.setResponsePort(this.udpMessageReceiver.getLocalPort());
                this.udpBroadcastMessageSender.sendMessage((Object)findServer);
            }
            catch (Exception e) {
                LOGGER.error("Error sending find server message", (Throwable)e);
            }
            Thread thread = new Thread("Server finder thread"){

                @Override
                public void run() {
                    while (CredentialsDialog.this.udpMessageReceiver != null) {
                        try {
                            final NetworkMessage networkMessage = CredentialsDialog.this.receiverQueue.receiveMessage();
                            Object messageData = networkMessage.getObject();
                            if (!(messageData instanceof ServerInfo)) continue;
                            final ServerInfo serverInfo = (ServerInfo)messageData;
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    String address = serverInfo.getAddress().replaceAll(Pattern.quote("{IP}"), networkMessage.getSender().getHostAddress());
                                    if (CredentialsDialog.this.urlComboBoxModel.getIndexOf(address) < 0) {
                                        CredentialsDialog.this.urlComboBoxModel.addElement(address);
                                    }
                                }
                            });
                            serverInfo.getAddress();
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    }

    @Override
    public void dispose() {
        try {
            this.udpMessageReceiver.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.udpBroadcastMessageSender.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.udpMessageReceiver = null;
        this.udpBroadcastMessageSender = null;
        super.dispose();
    }

    private void okAction() {
        String url = (String)this.urlField.getSelectedItem();
        this.credentials = new Credentials(url, this.usernameField.getText(), new String(this.passwordField.getPassword()));
        this.setVisible(false);
        this.dispose();
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public static Credentials showDialog(Frame window) {
        CredentialsDialog dialog = new CredentialsDialog(window, null);
        dialog.setLocationRelativeTo(window);
        dialog.setVisible(true);
        return dialog.getCredentials();
    }

    public static Credentials showDialog(Frame window, Map<String, String> messages) {
        CredentialsDialog dialog = new CredentialsDialog(window, messages);
        dialog.setLocationRelativeTo(window);
        dialog.setVisible(true);
        return dialog.getCredentials();
    }

    public static Credentials showDialog(Dialog window) {
        CredentialsDialog dialog = new CredentialsDialog(window, null);
        dialog.setLocationRelativeTo(window);
        dialog.setVisible(true);
        return dialog.getCredentials();
    }

    public static Credentials showDialog(Dialog window, Map<String, String> messages) {
        CredentialsDialog dialog = new CredentialsDialog(window, messages);
        dialog.setLocationRelativeTo(window);
        dialog.setVisible(true);
        return dialog.getCredentials();
    }

    public static void main(String[] args) {
        Credentials credentials = CredentialsDialog.showDialog((Frame)null);
        System.out.println("Credentials: " + (credentials == null ? "null" : credentials.toString()));
    }
}

