/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.semafor.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.common.utils.StringUtil;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchRound;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.common.tatami.Event;
import si.nevensrok.jtekma.common.tatami.FightOrder;
import si.nevensrok.jtekma.semafor.fw.SemaphoreManager;

public class FightDisplay
extends JPanel {
    private static final long serialVersionUID = -788963013363412500L;
    private static final int DEFAULT_FONT_SIZE = 35;
    private Font competitorNameFont;
    private SemaphoreManager semaphoreManager;
    private static final Color COMPETITOR_1_COLOR = Color.RED;
    private static final Color COMPETITOR_2_COLOR = Color.BLUE;

    public FightDisplay(SemaphoreManager semaphoreManager, FightOrder fightOrder, float fontScale) {
        this.semaphoreManager = semaphoreManager;
        this.competitorNameFont = new Font("SansSerif", 0, Math.round(35.0f * fontScale));
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(0, 140));
        if (fightOrder.getMatch() != null) {
            this.displayMatch(fightOrder);
        } else if (fightOrder.getEvent() != null) {
            this.displayEvent(fightOrder.getEvent());
        } else if (fightOrder.getDuoPresentation() != null) {
            this.displayDuoPresentation(fightOrder);
        }
    }

    private void displayMatch(FightOrder fightOrder) {
        Competitor competitor2;
        Match match = fightOrder.getMatch();
        this.setLayout(new GridLayout(3, 1));
        StringBuilder categoryText = new StringBuilder();
        categoryText.append(match.getCategory().getShortName());
        String additionalText = this.getAdditionalText(fightOrder);
        if (StringUtil.isNotEmpty((String)additionalText)) {
            categoryText.append(", ");
            categoryText.append(additionalText);
        }
        JLabel categoryLabel = new JLabel(categoryText.toString());
        this.add(categoryLabel);
        categoryLabel.setFont(this.competitorNameFont);
        String competitor1Text = "";
        String competitor2Text = "";
        Competitor competitor1 = match.getCompetitor1();
        if (competitor1 != null) {
            if (competitor1 instanceof PersonCompetitor) {
                PersonCompetitor personCompetitor = (PersonCompetitor)competitor1;
                competitor1Text = personCompetitor.getShortName();
            }
            if (competitor1 instanceof CoupleCompetitor) {
                CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor1;
                competitor1Text = coupleCompetitor.getShortName();
            }
            competitor1Text = competitor1Text + "/" + competitor1.getClub().getShortName();
        }
        if ((competitor2 = match.getCompetitor2()) != null) {
            if (competitor2 instanceof PersonCompetitor) {
                PersonCompetitor personCompetitor = (PersonCompetitor)competitor2;
                competitor2Text = personCompetitor.getShortName();
            }
            if (competitor2 instanceof CoupleCompetitor) {
                CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor2;
                competitor2Text = coupleCompetitor.getShortName();
            }
            competitor2Text = competitor2Text + "/" + competitor2.getClub().getShortName();
        }
        JPanel competitor1panel = new JPanel(new BorderLayout());
        competitor1panel.setBackground(Color.WHITE);
        this.add(competitor1panel);
        JPanel colorPanel1 = new JPanel();
        colorPanel1.setBackground(COMPETITOR_1_COLOR);
        colorPanel1.setPreferredSize(new Dimension(10, 0));
        competitor1panel.add((Component)colorPanel1, "West");
        JLabel competitor1label = new JLabel(competitor1Text);
        competitor1panel.add((Component)competitor1label, "Center");
        competitor1label.setBorder(BorderFactory.createLineBorder(COMPETITOR_1_COLOR, 1));
        competitor1label.setBackground(Color.WHITE);
        competitor1label.setOpaque(true);
        competitor1label.setFont(this.competitorNameFont);
        JPanel competitor2panel = new JPanel(new BorderLayout());
        competitor1panel.setBackground(Color.WHITE);
        this.add(competitor2panel);
        JPanel colorPanel2 = new JPanel();
        colorPanel2.setBackground(COMPETITOR_2_COLOR);
        colorPanel2.setPreferredSize(new Dimension(10, 0));
        competitor2panel.add((Component)colorPanel2, "West");
        JLabel competitor2label = new JLabel(competitor2Text);
        competitor2panel.add((Component)competitor2label, "Center");
        competitor2label.setBorder(BorderFactory.createLineBorder(COMPETITOR_2_COLOR, 1));
        competitor2label.setBackground(Color.WHITE);
        competitor2label.setOpaque(true);
        competitor2label.setFont(this.competitorNameFont);
    }

    private void displayEvent(Event event) {
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setLayout(new FlowLayout(1, 5, 5));
        for (String word : event.getText().split(" ")) {
            JLabel wordLabel = new JLabel(word);
            wordLabel.setFont(this.competitorNameFont);
            this.add(wordLabel);
        }
    }

    private void displayDuoPresentation(FightOrder fightOrder) {
        DuoPresentation duoPresentation = fightOrder.getDuoPresentation();
        this.setLayout(new GridLayout(2, 1));
        StringBuilder categoryText = new StringBuilder();
        categoryText.append(duoPresentation.getCategory().getShortName());
        String additionalText = this.getAdditionalText(fightOrder);
        if (StringUtil.isNotEmpty((String)additionalText)) {
            categoryText.append(", ");
            categoryText.append(additionalText);
        }
        JLabel categoryLabel = new JLabel(categoryText.toString());
        this.add(categoryLabel);
        categoryLabel.setFont(this.competitorNameFont);
        String competitor1Text = "";
        Competitor competitor = duoPresentation.getCompetitor();
        if (competitor != null) {
            if (competitor instanceof PersonCompetitor) {
                PersonCompetitor personCompetitor = (PersonCompetitor)competitor;
                competitor1Text = personCompetitor.getShortName();
            }
            if (competitor instanceof CoupleCompetitor) {
                CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor;
                competitor1Text = coupleCompetitor.getShortName();
            }
            competitor1Text = competitor1Text + "/" + competitor.getClub().getShortName();
        }
        JPanel competitor1panel = new JPanel(new BorderLayout());
        competitor1panel.setBackground(Color.WHITE);
        this.add(competitor1panel);
        JPanel colorPanel1 = new JPanel();
        colorPanel1.setBackground(COMPETITOR_1_COLOR);
        colorPanel1.setPreferredSize(new Dimension(10, 0));
        competitor1panel.add((Component)colorPanel1, "West");
        JLabel competitor1label = new JLabel(competitor1Text);
        competitor1panel.add((Component)competitor1label, "Center");
        competitor1label.setBorder(BorderFactory.createLineBorder(COMPETITOR_1_COLOR, 1));
        competitor1label.setBackground(Color.WHITE);
        competitor1label.setOpaque(true);
        competitor1label.setFont(this.competitorNameFont);
    }

    private String getAdditionalText(FightOrder fightOrder) {
        StringBuilder additionalText = new StringBuilder();
        if (fightOrder.getRound() != null) {
            if (fightOrder.getRound() == Round.ROUND_1 || fightOrder.getRound() == Round.ROUND_2 || fightOrder.getRound() == Round.ROUND_3) {
                additionalText.append(this.semaphoreManager.getLanguageText("text.round"));
                additionalText.append(" ");
                additionalText.append(fightOrder.getRound().ordinal() + 1);
            } else if (fightOrder.getRound() == Round.ROUND_4) {
                additionalText.append(this.semaphoreManager.getLanguageText("text.halfFinals"));
            } else if (fightOrder.getRound() == Round.ROUND_5) {
                if (fightOrder.getMatchRound() == MatchRound.FOR_3RD_PLACE) {
                    additionalText.append(this.semaphoreManager.getLanguageText("text.for3rdPlace"));
                } else {
                    additionalText.append(this.semaphoreManager.getLanguageText("text.finals"));
                }
            }
            if (additionalText.length() > 0) {
                if (fightOrder.getRank() == Rank.WORLD_LEVEL) {
                    additionalText.append(", ");
                    additionalText.append(this.semaphoreManager.getLanguageText("text.worldLevel"));
                } else if (fightOrder.getRank() == Rank.ADVANCED) {
                    additionalText.append(", ");
                    additionalText.append(this.semaphoreManager.getLanguageText("text.advancedLevel"));
                } else if (fightOrder.getRank() == Rank.NOVICE) {
                    additionalText.append(", ");
                    additionalText.append(this.semaphoreManager.getLanguageText("text.noviceLevel"));
                }
            }
            return additionalText.toString();
        }
        if (fightOrder.getMatchRound() != null) {
            if (fightOrder.getMatchRound() == MatchRound.FINALS) {
                return this.semaphoreManager.getLanguageText("text.finals");
            }
            if (fightOrder.getMatchRound() == MatchRound.HALF_FINALS) {
                return this.semaphoreManager.getLanguageText("text.halfFinals");
            }
            if (fightOrder.getMatchRound() == MatchRound.QUARTER_FINALS) {
                return this.semaphoreManager.getLanguageText("text.quarterFinals");
            }
            if (fightOrder.getMatchRound() == MatchRound.EIGHTH_FINALS) {
                return this.semaphoreManager.getLanguageText("text.eightFinals");
            }
            if (fightOrder.getMatchRound() == MatchRound.SIXTEEN_FINALS) {
                return this.semaphoreManager.getLanguageText("text.sixtinFinals");
            }
            if (fightOrder.getMatchRound() == MatchRound.THIRTY_TWO_FINALS) {
                return this.semaphoreManager.getLanguageText("text.tirtytwoFinals");
            }
            if (fightOrder.getMatchRound() == MatchRound.FOR_3RD_PLACE) {
                return this.semaphoreManager.getLanguageText("text.for3rdPlace");
            }
            if (fightOrder.getMatchRound() == MatchRound.REPECHAGE) {
                return this.semaphoreManager.getLanguageText("text.repechage");
            }
        }
        return null;
    }
}

