/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.mac;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.mac.MacResources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class MacDaemonBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(MacDaemonBundler.class.getName());
    private static final String TEMPLATE_LAUNCHD_PLIST = "launchd.plist.template";
    public static final String MAC_BUNDLER_PREFIX = "package/macosx" + File.separator;
    public static final BundlerParamInfo<File> CONFIG_ROOT = new StandardBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, params -> {
        File configRoot = new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)params), "macosx");
        configRoot.mkdirs();
        return configRoot;
    }, (s, p) -> new File((String)s));

    public MacDaemonBundler() {
        this.baseResourceLoader = MacResources.class;
    }

    private File getConfig_LaunchdPlist(Map<String, ? super Object> params) {
        return new File(CONFIG_ROOT.fetchFrom(params), "launchd.plist");
    }

    private void prepareConfigFiles(Map<String, ? super Object> params) throws IOException {
        File launchdPlistFile = this.getConfig_LaunchdPlist(params);
        launchdPlistFile.createNewFile();
        this.writeLaunchdPlist(launchdPlistFile, params);
    }

    private String getDaemonIdentifier(Map<String, ? super Object> params) {
        return ((String)StandardBundlerParam.IDENTIFIER.fetchFrom(params)).toLowerCase() + ".daemon";
    }

    public String getAppName(Map<String, ? super Object> params) {
        return (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + ".app";
    }

    private String getLauncherName(Map<String, ? super Object> params) {
        if (StandardBundlerParam.APP_NAME.fetchFrom(params) != null) {
            return (String)StandardBundlerParam.APP_NAME.fetchFrom(params);
        }
        return (String)StandardBundlerParam.MAIN_CLASS.fetchFrom(params);
    }

    private String getDaemonLauncherPath(Map<String, ? super Object> params) {
        return "/Applications/" + this.getAppName(params) + "/Contents/MacOS/" + this.getLauncherName(params);
    }

    private void writeLaunchdPlist(File file, Map<String, ? super Object> params) throws IOException {
        Log.verbose(MessageFormat.format(I18N.getString("message.preparing-launchd-plist"), file.getAbsolutePath()));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("DEPLOY_DAEMON_IDENTIFIER", this.getDaemonIdentifier(params));
        data.put("DEPLOY_DAEMON_LAUNCHER_PATH", this.getDaemonLauncherPath(params));
        data.put("DEPLOY_RUN_AT_LOAD", String.valueOf(StandardBundlerParam.START_ON_INSTALL.fetchFrom(params)));
        data.put("DEPLOY_KEEP_ALIVE", String.valueOf(StandardBundlerParam.RUN_AT_STARTUP.fetchFrom(params)));
        BufferedWriter w = new BufferedWriter(new FileWriter(file));
        w.write(this.preprocessTextResource(MAC_BUNDLER_PREFIX + this.getConfig_LaunchdPlist(params).getName(), I18N.getString("resource.launchd-config"), TEMPLATE_LAUNCHD_PLIST, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params)));
        ((Writer)w).close();
    }

    protected void cleanupConfigFiles(Map<String, ? super Object> params) {
        if (CONFIG_ROOT.fetchFrom(params) != null && this.getConfig_LaunchdPlist(params) != null) {
            this.getConfig_LaunchdPlist(params).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File doBundle(Map<String, ? super Object> params, File outputDirectory, boolean dependentTask) {
        File rootDirectory;
        block10: {
            block9: {
                if (!outputDirectory.isDirectory() && !outputDirectory.mkdirs()) {
                    throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), outputDirectory.getAbsolutePath()));
                }
                if (!outputDirectory.canWrite()) {
                    throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), outputDirectory.getAbsolutePath()));
                }
                rootDirectory = null;
                try {
                    this.prepareConfigFiles(params);
                    rootDirectory = new File(outputDirectory, (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + ".daemon");
                    IOUtils.deleteRecursive(rootDirectory);
                    rootDirectory.mkdirs();
                    if (!dependentTask) {
                        Log.info(MessageFormat.format(I18N.getString("message.creating-daemon-component"), rootDirectory.getAbsolutePath()));
                    }
                    File libraryDirectory = new File(rootDirectory, "Library");
                    libraryDirectory.mkdirs();
                    File launchDaemonsDirectory = new File(libraryDirectory, "LaunchDaemons");
                    launchDaemonsDirectory.mkdirs();
                    IOUtils.copyFile(this.getConfig_LaunchdPlist(params), new File(launchDaemonsDirectory, ((String)StandardBundlerParam.IDENTIFIER.fetchFrom(params)).toLowerCase() + ".launchd.plist"));
                    if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)).booleanValue()) break block9;
                    this.cleanupConfigFiles(params);
                    break block10;
                }
                catch (IOException ex) {
                    File file;
                    block11: {
                        try {
                            Log.verbose(ex);
                            file = null;
                            if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)).booleanValue()) break block11;
                            this.cleanupConfigFiles(params);
                        }
                        catch (Throwable throwable) {
                            if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)).booleanValue()) {
                                this.cleanupConfigFiles(params);
                            } else {
                                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(params).getAbsolutePath()));
                            }
                            throw throwable;
                        }
                    }
                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(params).getAbsolutePath()));
                    return file;
                }
            }
            Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(params).getAbsolutePath()));
        }
        return rootDirectory;
    }

    @Override
    public String getName() {
        return I18N.getString("bundle.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundle.description");
    }

    @Override
    public String getID() {
        return "mac.daemon";
    }

    @Override
    public String getBundleType() {
        return "INSTALLER";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        return MacDaemonBundler.getDaemonBundleParameters();
    }

    public static Collection<BundlerParamInfo<?>> getDaemonBundleParameters() {
        return Arrays.asList(StandardBundlerParam.APP_NAME, StandardBundlerParam.BUILD_ROOT, StandardBundlerParam.IDENTIFIER, StandardBundlerParam.START_ON_INSTALL, StandardBundlerParam.RUN_AT_STARTUP);
    }

    @Override
    public boolean validate(Map<String, ? super Object> params) throws UnsupportedPlatformException, ConfigException {
        try {
            return this.doValidate(params);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ConfigException) {
                throw (ConfigException)re.getCause();
            }
            throw new ConfigException(re);
        }
    }

    public boolean doValidate(Map<String, ? super Object> p) throws UnsupportedPlatformException, ConfigException {
        boolean systemWide;
        if (!System.getProperty("os.name").toLowerCase().contains("os x")) {
            throw new UnsupportedPlatformException();
        }
        boolean bl = systemWide = StandardBundlerParam.SYSTEM_WIDE.fetchFrom(p) == null || (Boolean)StandardBundlerParam.SYSTEM_WIDE.fetchFrom(p) != false;
        if (!systemWide) {
            throw new ConfigException(I18N.getString("error.no-support-for-peruser-daemons"), I18N.getString("error.no-support-for-peruser-daemons.advice"));
        }
        return true;
    }

    @Override
    public File execute(Map<String, ? super Object> params, File outputParentDir) {
        return this.doBundle(params, outputParentDir, false);
    }
}

