
/* Drop Tables */

DROP TABLE IF EXISTS locks;




/* Create Tables */
CREATE TABLE lockmembers
(
	memberid varchar(128) NOT NULL,
	lastcheckin timestamp with time zone NOT NULL,
	PRIMARY KEY (memberid)
) WITHOUT OIDS;

CREATE TABLE locks
(
	lockname varchar(4000) NOT NULL,	
	lockedat timestamp with time zone NOT NULL,
	memberid varchar(128) NOT NULL,
	PRIMARY KEY (lockname)
) WITHOUT OIDS;

/* Create indexes */
CREATE INDEX locks_member_fkey ON locks USING BTREE (memberid);


/* Foreign keys */
ALTER TABLE locks
	ADD FOREIGN KEY (memberid)
	REFERENCES lockmembers (memberid)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;
