/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.console;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import si.nevensrok.common.console.ConsoleOption;
import si.nevensrok.common.console.ConsoleOptionValue;
import si.nevensrok.common.console.ParseResult;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.common.utils.CollectionUtil;

public class ConsoleArgumentParser {
    private boolean caseSensitive = true;
    private int minimumArguments = 0;
    private int maximumArguments = Integer.MAX_VALUE;
    private List<ConsoleOption> consoleOptions = new LinkedList<ConsoleOption>();

    public ConsoleArgumentParser() {
    }

    public ConsoleArgumentParser(ConsoleOption ... consoleOptions) {
        this(Arrays.asList(consoleOptions));
    }

    public ConsoleArgumentParser(Collection<ConsoleOption> consoleOptions) {
        this.consoleOptions.addAll(consoleOptions);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public int getMinimumArguments() {
        return this.minimumArguments;
    }

    public void setMinimumArguments(int minimumArguments) {
        this.minimumArguments = minimumArguments;
    }

    public int getMaximumArguments() {
        return this.maximumArguments;
    }

    public void setMaximumArguments(int maximumArguments) {
        this.maximumArguments = maximumArguments;
    }

    public List<ConsoleOption> getConsoleOptions() {
        return this.consoleOptions;
    }

    public void setConsoleOptions(List<ConsoleOption> consoleOptions) {
        this.consoleOptions = consoleOptions;
    }

    public boolean validate(String[] args) {
        try {
            this.parseAndValidate(args);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private ConsoleOption getOptionByName(String optionName) {
        if (this.consoleOptions == null) {
            return null;
        }
        for (ConsoleOption consoleOption : this.consoleOptions) {
            if (this.isCaseSensitive()) {
                if (optionName.equals(consoleOption.getName())) {
                    return consoleOption;
                }
                if (!CollectionUtil.isNotEmpty(consoleOption.getAliases())) continue;
                for (String alias : consoleOption.getAliases()) {
                    if (!optionName.equals(alias)) continue;
                    return consoleOption;
                }
                continue;
            }
            if (optionName.equalsIgnoreCase(consoleOption.getName())) {
                return consoleOption;
            }
            if (!CollectionUtil.isNotEmpty(consoleOption.getAliases())) continue;
            for (String alias : consoleOption.getAliases()) {
                if (!optionName.equalsIgnoreCase(alias)) continue;
                return consoleOption;
            }
        }
        return null;
    }

    public ParseResult parse(String[] args) {
        return this.parse(args, false);
    }

    public ParseResult parseAndValidate(String[] args) {
        return this.parse(args, true);
    }

    private ParseResult parse(String[] args, boolean validate) {
        this.validateConsoleOptions();
        LinkedHashMap<String, ConsoleOptionValue> consoleOptionValues = new LinkedHashMap<String, ConsoleOptionValue>();
        LinkedList<String> normalArguments = new LinkedList<String>();
        boolean allNormalArguments = false;
        ConsoleOption currentConsoleOption = null;
        ConsoleOptionValue currentConsoleOptionValue = null;
        for (String argument : args) {
            if ("--".equals(argument)) {
                allNormalArguments = true;
                continue;
            }
            if (allNormalArguments) {
                normalArguments.add(argument);
                continue;
            }
            if (argument.startsWith("-")) {
                currentConsoleOption = this.getOptionByName(argument);
                if (currentConsoleOption == null) {
                    throw new IllegalArgumentException("Unknown option '" + argument + "'");
                }
                String optionName = this.isCaseSensitive() ? currentConsoleOption.getName() : currentConsoleOption.getName().toLowerCase();
                currentConsoleOptionValue = (ConsoleOptionValue)consoleOptionValues.get(optionName);
                if (currentConsoleOptionValue != null) continue;
                currentConsoleOptionValue = new ConsoleOptionValue(optionName, new LinkedList<String>());
                consoleOptionValues.put(optionName, currentConsoleOptionValue);
                continue;
            }
            if (currentConsoleOption == null) {
                normalArguments.add(argument);
                continue;
            }
            if (currentConsoleOption.getNumberOfAllArguments() <= currentConsoleOptionValue.getArguments().size()) {
                currentConsoleOption = null;
                currentConsoleOptionValue = null;
                normalArguments.add(argument);
                continue;
            }
            currentConsoleOptionValue.getArguments().add(argument);
        }
        if (validate) {
            if (normalArguments.size() > this.getMaximumArguments()) {
                throw new IllegalArgumentException("Argument count of " + normalArguments.size() + " is higher than " + this.getMaximumArguments() + " allowed");
            }
            if (normalArguments.size() < this.getMinimumArguments()) {
                throw new IllegalArgumentException("Argument count of " + normalArguments.size() + " is lower than " + this.getMinimumArguments() + " required");
            }
        }
        if (this.consoleOptions != null) {
            for (ConsoleOption consoleOption : this.consoleOptions) {
                ConsoleOptionValue consoleArgument = this.isCaseSensitive() ? (ConsoleOptionValue)consoleOptionValues.get(consoleOption.getName()) : (ConsoleOptionValue)consoleOptionValues.get(consoleOption.getName().toLowerCase());
                if (validate && consoleOption.isRequired() && consoleArgument == null) {
                    throw new IllegalArgumentException("Required option '" + consoleOption.getName() + "' is missing");
                }
                if (consoleArgument == null || !validate || consoleOption.getNumberOfRequiredArguments() <= consoleArgument.getArguments().size()) continue;
                throw new IllegalArgumentException("Required arguments for option '" + consoleOption.getName() + "' is " + consoleArgument.getArguments().size() + " that is lower than required " + consoleOption.getNumberOfRequiredArguments());
            }
        }
        return new ParseResult(consoleOptionValues, normalArguments);
    }

    private void validateConsoleOptions() {
        if (CollectionUtil.isEmpty(this.consoleOptions)) {
            return;
        }
        HashSet<String> allOptionsNames = new HashSet<String>();
        for (ConsoleOption consoleOption : this.consoleOptions) {
            if (this.isCaseSensitive()) {
                if (!allOptionsNames.add(consoleOption.getName())) {
                    throw new IllegalArgumentException("Option '" + consoleOption.getName() + "' is defined multiple times");
                }
                if (!CollectionUtil.isNotEmpty(consoleOption.getAliases())) continue;
                for (String alias : consoleOption.getAliases()) {
                    if (allOptionsNames.add(alias)) continue;
                    throw new IllegalArgumentException("Option '" + alias + "' is defined multiple times");
                }
                continue;
            }
            if (!allOptionsNames.add(consoleOption.getName().toLowerCase())) {
                throw new IllegalArgumentException("Option '" + consoleOption.getName() + "' is defined multiple times");
            }
            if (!CollectionUtil.isNotEmpty(consoleOption.getAliases())) continue;
            for (String alias : consoleOption.getAliases()) {
                if (allOptionsNames.add(alias.toLowerCase())) continue;
                throw new IllegalArgumentException("Option '" + alias + "' is defined multiple times");
            }
        }
    }

    public String toString() {
        return new ObjectToString(ConsoleArgumentParser.class).addProperty("caseSensitive", this.caseSensitive).addProperty("minimumArguments", this.minimumArguments).addProperty("maximumArguments", this.maximumArguments).addProperty("consoleOptions", this.consoleOptions).generateString();
    }
}

