/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.cache;

import java.io.Serializable;
import org.springframework.cache.Cache;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.common.utils.ObjectUtil;

public class CachedValue
implements Cache.ValueWrapper,
Serializable {
    private static final long serialVersionUID = 2261855668601673975L;
    private byte[] serializedValue;
    private Long validUntil;
    private long createdAt;

    public CachedValue(Object value, Long validUntil) {
        if (value != null) {
            this.serializedValue = ObjectUtil.serializeObject((Object)value);
        }
        this.validUntil = validUntil;
        this.createdAt = System.currentTimeMillis();
    }

    public Object get() {
        return this.getValue();
    }

    public Object getValue() {
        if (this.serializedValue == null) {
            return null;
        }
        return ObjectUtil.deserializeObject((byte[])this.serializedValue);
    }

    public Long getValidUntil() {
        return this.validUntil;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public String toString() {
        return new ObjectToString(CachedValue.class).addPropertyLength("serializedValue", this.serializedValue).addProperty("validUntil", (Object)this.validUntil).addProperty("createdAt", this.createdAt).generateString();
    }
}

