/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.ElementObserver;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.collections.SortHelper;
import com.sun.javafx.collections.SortableList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ModifiableObservableListBase;
import javafx.collections.ObservableList;
import javafx.util.Callback;

public class ObservableListWrapper<E>
extends ModifiableObservableListBase<E>
implements ObservableList<E>,
SortableList<E>,
RandomAccess {
    private final List<E> backingList;
    private final ElementObserver elementObserver;
    private SortHelper helper;

    public ObservableListWrapper(List<E> list) {
        this.backingList = list;
        this.elementObserver = null;
    }

    public ObservableListWrapper(List<E> list, Callback<E, Observable[]> extractor) {
        this.backingList = list;
        this.elementObserver = new ElementObserver<E>(extractor, new Callback<E, InvalidationListener>(){

            @Override
            public InvalidationListener call(final E e) {
                return new InvalidationListener(){

                    @Override
                    public void invalidated(Observable observable) {
                        ObservableListWrapper.this.beginChange();
                        int size = ObservableListWrapper.this.size();
                        for (int i = 0; i < size; ++i) {
                            if (ObservableListWrapper.this.get(i) != e) continue;
                            ObservableListWrapper.this.nextUpdate(i);
                        }
                        ObservableListWrapper.this.endChange();
                    }
                };
            }
        }, this);
        int sz = this.backingList.size();
        for (int i = 0; i < sz; ++i) {
            this.elementObserver.attachListener(this.backingList.get(i));
        }
    }

    @Override
    public E get(int index) {
        return this.backingList.get(index);
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    protected void doAdd(int index, E element) {
        if (this.elementObserver != null) {
            this.elementObserver.attachListener(element);
        }
        this.backingList.add(index, element);
    }

    @Override
    protected E doSet(int index, E element) {
        E removed = this.backingList.set(index, element);
        if (this.elementObserver != null) {
            this.elementObserver.detachListener(removed);
            this.elementObserver.attachListener(element);
        }
        return removed;
    }

    @Override
    protected E doRemove(int index) {
        E removed = this.backingList.remove(index);
        if (this.elementObserver != null) {
            this.elementObserver.detachListener(removed);
        }
        return removed;
    }

    @Override
    public int indexOf(Object o) {
        return this.backingList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.backingList.lastIndexOf(o);
    }

    @Override
    public boolean contains(Object o) {
        return this.backingList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.backingList.containsAll(c);
    }

    @Override
    public void clear() {
        if (this.elementObserver != null) {
            int sz = this.size();
            for (int i = 0; i < sz; ++i) {
                this.elementObserver.detachListener(this.get(i));
            }
        }
        if (this.hasListeners()) {
            this.beginChange();
            this.nextRemove(0, this);
        }
        this.backingList.clear();
        ++this.modCount;
        if (this.hasListeners()) {
            this.endChange();
        }
    }

    @Override
    public void remove(int fromIndex, int toIndex) {
        this.beginChange();
        for (int i = fromIndex; i < toIndex; ++i) {
            this.remove(fromIndex);
        }
        this.endChange();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.beginChange();
        BitSet bs = new BitSet(c.size());
        for (int i = 0; i < this.size(); ++i) {
            if (!c.contains(this.get(i))) continue;
            bs.set(i);
        }
        if (!bs.isEmpty()) {
            int cur = this.size();
            while ((cur = bs.previousSetBit(cur - 1)) >= 0) {
                this.remove(cur);
            }
        }
        this.endChange();
        return !bs.isEmpty();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.beginChange();
        BitSet bs = new BitSet(c.size());
        for (int i = 0; i < this.size(); ++i) {
            if (c.contains(this.get(i))) continue;
            bs.set(i);
        }
        if (!bs.isEmpty()) {
            int cur = this.size();
            while ((cur = bs.previousSetBit(cur - 1)) >= 0) {
                this.remove(cur);
            }
        }
        this.endChange();
        return !bs.isEmpty();
    }

    @Override
    public void sort() {
        if (this.backingList.isEmpty()) {
            return;
        }
        int[] perm = this.getSortHelper().sort(this.backingList);
        this.fireChange(new NonIterableChange.SimplePermutationChange(0, this.size(), perm, this));
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        if (this.backingList.isEmpty()) {
            return;
        }
        int[] perm = this.getSortHelper().sort(this.backingList, comparator);
        this.fireChange(new NonIterableChange.SimplePermutationChange(0, this.size(), perm, this));
    }

    private SortHelper getSortHelper() {
        if (this.helper == null) {
            this.helper = new SortHelper();
        }
        return this.helper;
    }
}

