/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import si.nevensrok.common.utils.StreamUtil;

public final class FileUtil {
    private FileUtil() {
    }

    public static File getTempDirectory() {
        String tempDirectoryPath = System.getProperty("java.io.tmpdir");
        return new File(tempDirectoryPath);
    }

    public static byte[] readFile(String file) throws IOException {
        return FileUtil.readFile(new File(file));
    }

    public static byte[] readFile(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] byArray = StreamUtil.readData(inputStream);
            return byArray;
        }
    }

    public static void writeFile(String file, byte[] data) throws IOException {
        FileUtil.writeFile(new File(file), data);
    }

    public static void writeFile(File file, byte[] data) throws IOException {
        FileUtil.writeFile(file, data, 0, data.length);
    }

    public static void writeFile(File file, byte[] data, int offset, int length) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            outputStream.write(data, offset, length);
            outputStream.flush();
        }
    }

    public static boolean deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return false;
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Given file is not directory");
        }
        for (File subFile : directory.listFiles()) {
            if (!(subFile.isFile() ? !subFile.delete() : !FileUtil.deleteDirectory(subFile))) continue;
            return false;
        }
        return directory.delete();
    }
}

