/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.remoting;

import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.network.NetworkMessageHandler;
import si.nevensrok.common.network.tcp.TcpNetworkClient;
import si.nevensrok.common.remoting.RemoteExecutionException;
import si.nevensrok.common.remoting.RemoteMethodInvocation;
import si.nevensrok.common.remoting.RemoteMethodInvocationResult;
import si.nevensrok.common.utils.StringUtil;

public class TcpServiceProxyFactoryBean
implements FactoryBean<Object>,
MethodInterceptor,
InitializingBean,
DisposableBean,
NetworkMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpServiceProxyFactoryBean.class);
    private TcpNetworkClient tcpNetworkClient;
    private String address;
    private int port;
    private String serviceName;
    private Class<?> serviceInterface;
    private int connectTimeout = 10000;
    private int readTimeout = 60000;
    private boolean internalTcpClient = false;
    private Object serviceProxy;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Map<String, RemoteMethodInvocationResult> responses = new HashMap<String, RemoteMethodInvocationResult>();

    public TcpNetworkClient getTcpNetworkClient() {
        return this.tcpNetworkClient;
    }

    public void setTcpNetworkClient(TcpNetworkClient tcpNetworkClient) {
        this.tcpNetworkClient = tcpNetworkClient;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Class<?> getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(Class<?> serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtil.isEmpty((String)this.getServiceName())) {
            throw new IllegalArgumentException("Property 'serviceName' is required");
        }
        if (this.getServiceInterface() == null) {
            throw new IllegalArgumentException("Property 'serviceInterface' is required");
        }
        if (this.tcpNetworkClient == null) {
            if (StringUtil.isEmpty((String)this.getAddress())) {
                throw new IllegalArgumentException("Property 'address' is required");
            }
            if (this.getPort() < 1) {
                throw new IllegalArgumentException("Property 'port' is required");
            }
            this.internalTcpClient = true;
            this.tcpNetworkClient = new TcpNetworkClient();
            this.tcpNetworkClient.setAddress(this.getAddress());
            this.tcpNetworkClient.setPort(Integer.valueOf(this.getPort()));
            this.tcpNetworkClient.setConnectTimeout(this.getConnectTimeout());
            this.tcpNetworkClient.afterPropertiesSet();
        }
        this.tcpNetworkClient.setNetworkMessageHandler((NetworkMessageHandler)this);
        this.serviceProxy = new ProxyFactory(this.getServiceInterface(), (Interceptor)this).getProxy(this.beanClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        Map<String, RemoteMethodInvocationResult> map = this.responses;
        synchronized (map) {
            this.responses.clear();
        }
        if (this.internalTcpClient && this.tcpNetworkClient != null) {
            try {
                this.tcpNetworkClient.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tcpNetworkClient = null;
        }
    }

    public Object getObject() throws Exception {
        return this.serviceProxy;
    }

    public Class<?> getObjectType() {
        return this.serviceInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        this.tcpNetworkClient.waitForConnection((long)this.getConnectTimeout());
        String methodName = invocation.getMethod().getName();
        Class<?>[] parameterTypes = invocation.getMethod().getParameterTypes();
        Object[] arguments = invocation.getArguments();
        RemoteMethodInvocation remoteMethodInvocation = new RemoteMethodInvocation();
        remoteMethodInvocation.setServiceName(this.getServiceName());
        remoteMethodInvocation.setMethodName(methodName);
        remoteMethodInvocation.setParameterTypes(parameterTypes);
        remoteMethodInvocation.setArguments(arguments);
        Map<String, RemoteMethodInvocationResult> map = this.responses;
        synchronized (map) {
            this.responses.put(remoteMethodInvocation.getId(), null);
        }
        long waitUntil = System.currentTimeMillis() + (long)this.getReadTimeout();
        this.tcpNetworkClient.sendMessage((Object)remoteMethodInvocation);
        String id = remoteMethodInvocation.getId();
        Map<String, RemoteMethodInvocationResult> map2 = this.responses;
        synchronized (map2) {
            while (this.tcpNetworkClient != null) {
                RemoteMethodInvocationResult remoteMethodInvocationResult = this.responses.get(id);
                if (remoteMethodInvocationResult == null) {
                    long waitTime = waitUntil - System.currentTimeMillis();
                    if (waitTime <= 0L) {
                        throw new RemoteExecutionException("Response timeout reached");
                    }
                    this.responses.wait(waitTime);
                    continue;
                }
                this.responses.remove(id);
                if (remoteMethodInvocationResult.getException() != null) {
                    throw remoteMethodInvocationResult.getException();
                }
                return remoteMethodInvocationResult.getResult();
            }
        }
        throw new RemoteExecutionException("Connection is closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(NetworkMessage networkMessage) throws Exception {
        try {
            RemoteMethodInvocationResult remoteMethodInvocationResult = (RemoteMethodInvocationResult)networkMessage.getObject();
            String id = remoteMethodInvocationResult.getId();
            if (id == null) {
                return;
            }
            Map<String, RemoteMethodInvocationResult> map = this.responses;
            synchronized (map) {
                if (!this.responses.containsKey(id)) {
                    return;
                }
                this.responses.put(id, remoteMethodInvocationResult);
                this.responses.notifyAll();
            }
        }
        catch (Throwable e) {
            LOGGER.debug("Error handing response message", e);
        }
    }

    public boolean isSingleton() {
        return true;
    }
}

