/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.remoting;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.network.NetworkMessageHandler;
import si.nevensrok.common.network.tcp.TcpNetworkConnection;
import si.nevensrok.common.remoting.RemoteExecutionException;
import si.nevensrok.common.remoting.RemoteMethodInvocation;
import si.nevensrok.common.remoting.RemoteMethodInvocationResult;
import si.nevensrok.common.remoting.ServiceExporter;

public class TcpRequestHandler
implements NetworkMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpRequestHandler.class);
    private TcpNetworkConnection networkConnection;
    private Map<String, ServiceExporter> serviceExporters;

    public TcpRequestHandler(TcpNetworkConnection networkConnection, Map<String, ServiceExporter> serviceExporters) {
        this.networkConnection = networkConnection;
        this.serviceExporters = serviceExporters;
    }

    public void handleMessage(NetworkMessage networkMessage) throws Exception {
        RemoteMethodInvocationResult remoteMethodInvocationResult = new RemoteMethodInvocationResult();
        try {
            RemoteMethodInvocation remoteMethodInvocation = (RemoteMethodInvocation)networkMessage.getObject();
            remoteMethodInvocationResult.setId(remoteMethodInvocation.getId());
            ServiceExporter serviceExporter = this.serviceExporters.get(remoteMethodInvocation.getServiceName());
            if (serviceExporter == null) {
                throw new RemoteExecutionException("Service '" + remoteMethodInvocation.getServiceName() + "' not found");
            }
            Object result = serviceExporter.invoke(remoteMethodInvocation.getMethodName(), remoteMethodInvocation.getParameterTypes(), remoteMethodInvocation.getArguments());
            remoteMethodInvocationResult.setResult(result);
        }
        catch (InvocationTargetException e) {
            remoteMethodInvocationResult.setException(e.getCause());
        }
        catch (RemoteExecutionException e) {
            remoteMethodInvocationResult.setException(e);
        }
        catch (Throwable e) {
            LOGGER.debug("Error executing remove service call", e);
            remoteMethodInvocationResult.setException(new RemoteExecutionException(e.getMessage()));
        }
        this.networkConnection.sendMessage((Object)remoteMethodInvocationResult);
    }
}

