/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.semafor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import si.nevensrok.jtekma.semafor.common.SemaphoreData;
import si.nevensrok.jtekma.semafor.gui.SemaphoreWindow;

public class SettingsDialog
extends JDialog
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsDialog.class);
    private static final int LABEL_WIDTH = 290;
    private static final int LABEL_HEIGHT = 20;
    private static final int FIELD_WIDTH = 200;
    private static final int FIELD_HEIGHT = 20;
    private static final int PANEL_HORIZONTAL_GAP = 10;
    private static final int PANEL_VERTICAL_GAP = 5;
    private ApplicationContext applicationContext;
    private SemaphoreWindow semaphoreWindow;
    private SemaphoreData semaphoreData;
    private JButton saveButton = new JButton("Save");
    private JButton cancelButton = new JButton("Cancel");
    private JLabel languageLabel = new JLabel("Language");
    private JComboBox<String> languagesComboBox = new JComboBox();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setSemaphoreWindow(SemaphoreWindow semaphoreWindow) {
        this.semaphoreWindow = semaphoreWindow;
    }

    public void setSemaphoreData(SemaphoreData semaphoreData) {
        this.semaphoreData = semaphoreData;
    }

    public String getLanguageText(String key) {
        if (this.semaphoreData == null) {
            return key;
        }
        return this.applicationContext.getMessage(key, null, key, this.semaphoreData.getLocale());
    }

    public void afterPropertiesSet() throws Exception {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SettingsDialog.this.languagesComboBox.getModel() instanceof DefaultComboBoxModel) {
                    DefaultComboBoxModel comboBoxModel = (DefaultComboBoxModel)SettingsDialog.this.languagesComboBox.getModel();
                    comboBoxModel.addElement(SettingsDialog.this.getLanguageText("locale.english"));
                    comboBoxModel.addElement(SettingsDialog.this.getLanguageText("locale.slovenian"));
                }
            }
        });
    }

    public void destroy() throws Exception {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SettingsDialog.this.setVisible(false);
                SettingsDialog.this.dispose();
            }
        });
    }

    public SettingsDialog() {
        this.setAlwaysOnTop(true);
        this.setSize(600, 150);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        JPanel settingsPanel = new JPanel();
        this.add((Component)settingsPanel, "Center");
        settingsPanel.setLayout(new GridLayout(1, 1));
        JPanel languagePanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(languagePanel);
        languagePanel.add(this.languageLabel);
        languagePanel.add(this.languagesComboBox);
        this.languageLabel.setPreferredSize(new Dimension(290, 20));
        this.languagesComboBox.setPreferredSize(new Dimension(200, 20));
        JPanel buttonsPanel = new JPanel(new FlowLayout(1, 20, 10));
        this.add((Component)buttonsPanel, "South");
        buttonsPanel.add(this.saveButton);
        buttonsPanel.add(this.cancelButton);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SettingsDialog.this.languagesComboBox.getSelectedIndex() == 0) {
                    SettingsDialog.this.semaphoreData.setLocale(new Locale("en"));
                } else if (SettingsDialog.this.languagesComboBox.getSelectedIndex() == 1) {
                    SettingsDialog.this.semaphoreData.setLocale(new Locale("sl"));
                }
                SettingsDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.setVisible(false);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SettingsDialog.this.setVisible(false);
                }
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.setLocationRelativeTo(this.semaphoreWindow);
            this.setTitle(this.getLanguageText("title.settings"));
            this.languageLabel.setText(this.getLanguageText("text.language"));
            this.saveButton.setText(this.getLanguageText("text.save"));
            this.cancelButton.setText(this.getLanguageText("text.cancel"));
            this.languagesComboBox.setSelectedItem(this.getLanguageText("locale.current"));
            this.revalidate();
            this.repaint();
        }
    }
}

