/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.util;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.stage.StageHelper;
import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Stop;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;

public class Utils {
    public static float clamp(float min, float value, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int clamp(int min, int value, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double clamp(double min, double value, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double clampMin(double value, double min) {
        if (value < min) {
            return min;
        }
        return value;
    }

    public static int clampMax(int value, int max) {
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double nearest(double less, double value, double more) {
        double lessDiff = value - less;
        double moreDiff = more - value;
        if (lessDiff < moreDiff) {
            return less;
        }
        return more;
    }

    public static String stripQuotes(String str) {
        int endIndex;
        char closeQuote;
        if (str == null) {
            return str;
        }
        if (str.length() == 0) {
            return str;
        }
        int beginIndex = 0;
        char openQuote = str.charAt(beginIndex);
        if (openQuote == '\"' || openQuote == '\'') {
            ++beginIndex;
        }
        if ((closeQuote = str.charAt((endIndex = str.length()) - 1)) == '\"' || closeQuote == '\'') {
            --endIndex;
        }
        if (endIndex - beginIndex < 0) {
            return str;
        }
        return str.substring(beginIndex, endIndex);
    }

    public static String[] split(String str, String separator) {
        if (str == null || str.length() == 0) {
            return new String[0];
        }
        if (separator == null || separator.length() == 0) {
            return new String[0];
        }
        if (separator.length() > str.length()) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        int index = str.indexOf(separator);
        while (index >= 0) {
            String newStr = str.substring(0, index);
            if (newStr != null && newStr.length() > 0) {
                result.add(newStr);
            }
            str = str.substring(index + separator.length());
            index = str.indexOf(separator);
        }
        if (str != null && str.length() > 0) {
            result.add(str);
        }
        return result.toArray(new String[0]);
    }

    public static boolean contains(String src, String s) {
        if (src == null || src.length() == 0) {
            return false;
        }
        if (s == null || s.length() == 0) {
            return false;
        }
        if (s.length() > src.length()) {
            return false;
        }
        return src.indexOf(s) > -1;
    }

    public static double calculateBrightness(Color color) {
        return 0.3 * color.getRed() + 0.59 * color.getGreen() + 0.11 * color.getBlue();
    }

    public static Color deriveColor(Color c, double brightness) {
        double baseBrightness = Utils.calculateBrightness(c);
        double calcBrightness = brightness;
        if (brightness > 0.0) {
            if (baseBrightness > 0.85) {
                calcBrightness *= 1.6;
            } else if (!(baseBrightness > 0.6)) {
                calcBrightness = baseBrightness > 0.5 ? (calcBrightness *= 0.9) : (baseBrightness > 0.4 ? (calcBrightness *= 0.8) : (baseBrightness > 0.3 ? (calcBrightness *= 0.7) : (calcBrightness *= 0.6)));
            }
        } else if (baseBrightness < 0.2) {
            calcBrightness *= 0.6;
        }
        if (calcBrightness < -1.0) {
            calcBrightness = -1.0;
        } else if (calcBrightness > 1.0) {
            calcBrightness = 1.0;
        }
        double[] hsb = Utils.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue());
        if (calcBrightness > 0.0) {
            hsb[1] = hsb[1] * (1.0 - calcBrightness);
            hsb[2] = hsb[2] + (1.0 - hsb[2]) * calcBrightness;
        } else {
            hsb[2] = hsb[2] * (calcBrightness + 1.0);
        }
        if (hsb[1] < 0.0) {
            hsb[1] = 0.0;
        } else if (hsb[1] > 1.0) {
            hsb[1] = 1.0;
        }
        if (hsb[2] < 0.0) {
            hsb[2] = 0.0;
        } else if (hsb[2] > 1.0) {
            hsb[2] = 1.0;
        }
        Color c2 = Color.hsb((int)hsb[0], hsb[1], hsb[2], c.getOpacity());
        return Color.hsb((int)hsb[0], hsb[1], hsb[2], c.getOpacity());
    }

    private static Color interpolateLinear(double position, Color color1, Color color2) {
        Color c1Linear = Utils.convertSRGBtoLinearRGB(color1);
        Color c2Linear = Utils.convertSRGBtoLinearRGB(color2);
        return Utils.convertLinearRGBtoSRGB(Color.color(c1Linear.getRed() + (c2Linear.getRed() - c1Linear.getRed()) * position, c1Linear.getGreen() + (c2Linear.getGreen() - c1Linear.getGreen()) * position, c1Linear.getBlue() + (c2Linear.getBlue() - c1Linear.getBlue()) * position, c1Linear.getOpacity() + (c2Linear.getOpacity() - c1Linear.getOpacity()) * position));
    }

    private static Color ladder(double position, Stop[] stops) {
        Stop prevStop = null;
        for (int i = 0; i < stops.length; ++i) {
            Stop stop = stops[i];
            if (position <= stop.getOffset()) {
                if (prevStop == null) {
                    return stop.getColor();
                }
                return Utils.interpolateLinear((position - prevStop.getOffset()) / (stop.getOffset() - prevStop.getOffset()), prevStop.getColor(), stop.getColor());
            }
            prevStop = stop;
        }
        return prevStop.getColor();
    }

    public static Color ladder(Color color, Stop[] stops) {
        return Utils.ladder(Utils.calculateBrightness(color), stops);
    }

    public static double[] HSBtoRGB(double hue, double saturation, double brightness) {
        double normalizedHue = (hue % 360.0 + 360.0) % 360.0;
        hue = normalizedHue / 360.0;
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        if (saturation == 0.0) {
            g = b = brightness;
            r = b;
        } else {
            double h = (hue - Math.floor(hue)) * 6.0;
            double f = h - Math.floor(h);
            double p = brightness * (1.0 - saturation);
            double q = brightness * (1.0 - saturation * f);
            double t = brightness * (1.0 - saturation * (1.0 - f));
            switch ((int)h) {
                case 0: {
                    r = brightness;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = brightness;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = brightness;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = brightness;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = brightness;
                    break;
                }
                case 5: {
                    r = brightness;
                    g = p;
                    b = q;
                }
            }
        }
        double[] f = new double[]{r, g, b};
        return f;
    }

    public static double[] RGBtoHSB(double r, double g, double b) {
        double hue;
        double cmin;
        double cmax;
        double[] hsbvals = new double[3];
        double d = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        double d2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        double brightness = cmax;
        double saturation = cmax != 0.0 ? (cmax - cmin) / cmax : 0.0;
        if (saturation == 0.0) {
            hue = 0.0;
        } else {
            double redc = (cmax - r) / (cmax - cmin);
            double greenc = (cmax - g) / (cmax - cmin);
            double bluec = (cmax - b) / (cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0 + redc - bluec : 4.0 + greenc - redc);
            if ((hue /= 6.0) < 0.0) {
                hue += 1.0;
            }
        }
        hsbvals[0] = hue * 360.0;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    public static Color convertSRGBtoLinearRGB(Color color) {
        double[] colors = new double[]{color.getRed(), color.getGreen(), color.getBlue()};
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = colors[i] <= 0.04045 ? colors[i] / 12.92 : Math.pow((colors[i] + 0.055) / 1.055, 2.4);
        }
        return Color.color(colors[0], colors[1], colors[2], color.getOpacity());
    }

    public static Color convertLinearRGBtoSRGB(Color color) {
        double[] colors = new double[]{color.getRed(), color.getGreen(), color.getBlue()};
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = colors[i] <= 0.0031308 ? colors[i] * 12.92 : 1.055 * Math.pow(colors[i], 0.4166666666666667) - 0.055;
        }
        return Color.color(colors[0], colors[1], colors[2], color.getOpacity());
    }

    public static double sum(double[] values) {
        double sum = 0.0;
        for (double v : values) {
            sum += v;
        }
        return sum / (double)values.length;
    }

    public static Point2D pointRelativeTo(Node parent, Node node, HPos hpos, VPos vpos, double dx, double dy, boolean reposition) {
        double nodeWidth = node.getLayoutBounds().getWidth();
        double nodeHeight = node.getLayoutBounds().getHeight();
        return Utils.pointRelativeTo(parent, nodeWidth, nodeHeight, hpos, vpos, dx, dy, reposition);
    }

    public static Point2D pointRelativeTo(Node parent, double anchorWidth, double anchorHeight, HPos hpos, VPos vpos, double dx, double dy, boolean reposition) {
        Bounds parentBounds = Utils.getBounds(parent);
        Scene scene = parent.getScene();
        NodeOrientation orientation = parent.getEffectiveNodeOrientation();
        if (orientation == NodeOrientation.RIGHT_TO_LEFT) {
            if (hpos == HPos.LEFT) {
                hpos = HPos.RIGHT;
            } else if (hpos == HPos.RIGHT) {
                hpos = HPos.LEFT;
            }
            dx *= -1.0;
        }
        double layoutX = Utils.positionX(parentBounds, anchorWidth, hpos) + dx;
        double layoutY = Utils.positionY(parentBounds, anchorHeight, vpos) + dy;
        if (orientation == NodeOrientation.RIGHT_TO_LEFT && hpos == HPos.CENTER) {
            layoutX = scene.getWindow() instanceof Stage ? layoutX + parentBounds.getWidth() - anchorWidth : layoutX - parentBounds.getWidth() - anchorWidth;
        }
        if (reposition) {
            return Utils.pointRelativeTo((Object)parent, anchorWidth, anchorHeight, layoutX, layoutY, hpos, vpos);
        }
        return new Point2D(layoutX, layoutY);
    }

    public static Point2D pointRelativeTo(Object parent, double width, double height, double screenX, double screenY, HPos hpos, VPos vpos) {
        Rectangle2D screenBounds;
        double finalScreenX = screenX;
        double finalScreenY = screenY;
        Bounds parentBounds = Utils.getBounds(parent);
        Screen currentScreen = Utils.getScreen(parent);
        Rectangle2D rectangle2D = screenBounds = Utils.hasFullScreenStage(currentScreen) ? currentScreen.getBounds() : currentScreen.getVisualBounds();
        if (hpos != null) {
            if (finalScreenX + width > screenBounds.getMaxX()) {
                finalScreenX = Utils.positionX(parentBounds, width, Utils.getHPosOpposite(hpos, vpos));
            }
            if (finalScreenX < screenBounds.getMinX()) {
                finalScreenX = Utils.positionX(parentBounds, width, Utils.getHPosOpposite(hpos, vpos));
            }
        }
        if (vpos != null) {
            if (finalScreenY + height > screenBounds.getMaxY()) {
                finalScreenY = Utils.positionY(parentBounds, height, Utils.getVPosOpposite(hpos, vpos));
            }
            if (finalScreenY < screenBounds.getMinY()) {
                finalScreenY = Utils.positionY(parentBounds, height, Utils.getVPosOpposite(hpos, vpos));
            }
        }
        if (finalScreenX + width > screenBounds.getMaxX()) {
            finalScreenX -= finalScreenX + width - screenBounds.getMaxX();
        }
        if (finalScreenX < screenBounds.getMinX()) {
            finalScreenX = screenBounds.getMinX();
        }
        if (finalScreenY + height > screenBounds.getMaxY()) {
            finalScreenY -= finalScreenY + height - screenBounds.getMaxY();
        }
        if (finalScreenY < screenBounds.getMinY()) {
            finalScreenY = screenBounds.getMinY();
        }
        return new Point2D(finalScreenX, finalScreenY);
    }

    private static double positionX(Bounds parentBounds, double width, HPos hpos) {
        if (hpos == HPos.CENTER) {
            return parentBounds.getMinX();
        }
        if (hpos == HPos.RIGHT) {
            return parentBounds.getMaxX();
        }
        if (hpos == HPos.LEFT) {
            return parentBounds.getMinX() - width;
        }
        return 0.0;
    }

    private static double positionY(Bounds parentBounds, double height, VPos vpos) {
        if (vpos == VPos.BOTTOM) {
            return parentBounds.getMaxY();
        }
        if (vpos == VPos.CENTER) {
            return parentBounds.getMinY();
        }
        if (vpos == VPos.TOP) {
            return parentBounds.getMinY() - height;
        }
        return 0.0;
    }

    private static Bounds getBounds(Object obj) {
        if (obj instanceof Node) {
            Node n = (Node)obj;
            Bounds b = n.localToScreen(n.getLayoutBounds());
            return b != null ? b : new BoundingBox(0.0, 0.0, 0.0, 0.0);
        }
        if (obj instanceof Window) {
            Window window = (Window)obj;
            return new BoundingBox(window.getX(), window.getY(), window.getWidth(), window.getHeight());
        }
        return new BoundingBox(0.0, 0.0, 0.0, 0.0);
    }

    private static HPos getHPosOpposite(HPos hpos, VPos vpos) {
        if (vpos == VPos.CENTER) {
            if (hpos == HPos.LEFT) {
                return HPos.RIGHT;
            }
            if (hpos == HPos.RIGHT) {
                return HPos.LEFT;
            }
            if (hpos == HPos.CENTER) {
                return HPos.CENTER;
            }
            return HPos.CENTER;
        }
        return HPos.CENTER;
    }

    private static VPos getVPosOpposite(HPos hpos, VPos vpos) {
        if (hpos == HPos.CENTER) {
            if (vpos == VPos.BASELINE) {
                return VPos.BASELINE;
            }
            if (vpos == VPos.BOTTOM) {
                return VPos.TOP;
            }
            if (vpos == VPos.CENTER) {
                return VPos.CENTER;
            }
            if (vpos == VPos.TOP) {
                return VPos.BOTTOM;
            }
            return VPos.CENTER;
        }
        return VPos.CENTER;
    }

    public static boolean hasFullScreenStage(Screen screen) {
        ObservableList<Stage> allStages = StageHelper.getStages();
        for (Stage stage : allStages) {
            if (!stage.isFullScreen() || Utils.getScreen(stage) != screen) continue;
            return true;
        }
        return false;
    }

    public static boolean isQVGAScreen() {
        Rectangle2D bounds = Screen.getPrimary().getBounds();
        return bounds.getWidth() == 320.0 && bounds.getHeight() == 240.0 || bounds.getWidth() == 240.0 && bounds.getHeight() == 320.0;
    }

    public static Screen getScreen(Object obj) {
        Bounds parentBounds = Utils.getBounds(obj);
        Rectangle2D rect = new Rectangle2D(parentBounds.getMinX(), parentBounds.getMinY(), parentBounds.getWidth(), parentBounds.getHeight());
        return Utils.getScreenForRectangle(rect);
    }

    public static Screen getScreenForRectangle(Rectangle2D rect) {
        ObservableList<Screen> screens = Screen.getScreens();
        double rectX0 = rect.getMinX();
        double rectX1 = rect.getMaxX();
        double rectY0 = rect.getMinY();
        double rectY1 = rect.getMaxY();
        Screen selectedScreen = null;
        double maxIntersection = 0.0;
        for (Screen screen : screens) {
            Rectangle2D screenBounds = screen.getBounds();
            double intersection = Utils.getIntersectionLength(rectX0, rectX1, screenBounds.getMinX(), screenBounds.getMaxX()) * Utils.getIntersectionLength(rectY0, rectY1, screenBounds.getMinY(), screenBounds.getMaxY());
            if (!(maxIntersection < intersection)) continue;
            maxIntersection = intersection;
            selectedScreen = screen;
        }
        if (selectedScreen != null) {
            return selectedScreen;
        }
        selectedScreen = Screen.getPrimary();
        double minDistance = Double.MAX_VALUE;
        for (Screen screen : screens) {
            double dy;
            Rectangle2D screenBounds = screen.getBounds();
            double dx = Utils.getOuterDistance(rectX0, rectX1, screenBounds.getMinX(), screenBounds.getMaxX());
            double distance = dx * dx + (dy = Utils.getOuterDistance(rectY0, rectY1, screenBounds.getMinY(), screenBounds.getMaxY())) * dy;
            if (!(minDistance > distance)) continue;
            minDistance = distance;
            selectedScreen = screen;
        }
        return selectedScreen;
    }

    public static Screen getScreenForPoint(double x, double y) {
        ObservableList<Screen> screens = Screen.getScreens();
        for (Screen screen : screens) {
            Rectangle2D screenBounds = screen.getBounds();
            if (!(x >= screenBounds.getMinX()) || !(x < screenBounds.getMaxX()) || !(y >= screenBounds.getMinY()) || !(y < screenBounds.getMaxY())) continue;
            return screen;
        }
        Screen selectedScreen = Screen.getPrimary();
        double minDistance = Double.MAX_VALUE;
        for (Screen screen : screens) {
            double dy;
            Rectangle2D screenBounds = screen.getBounds();
            double dx = Utils.getOuterDistance(screenBounds.getMinX(), screenBounds.getMaxX(), x);
            double distance = dx * dx + (dy = Utils.getOuterDistance(screenBounds.getMinY(), screenBounds.getMaxY(), y)) * dy;
            if (!(minDistance >= distance)) continue;
            minDistance = distance;
            selectedScreen = screen;
        }
        return selectedScreen;
    }

    private static double getIntersectionLength(double a0, double a1, double b0, double b1) {
        return a0 <= b0 ? Utils.getIntersectionLengthImpl(b0, b1, a1) : Utils.getIntersectionLengthImpl(a0, a1, b1);
    }

    private static double getIntersectionLengthImpl(double v0, double v1, double v) {
        if (v <= v0) {
            return 0.0;
        }
        return v <= v1 ? v - v0 : v1 - v0;
    }

    private static double getOuterDistance(double a0, double a1, double b0, double b1) {
        if (a1 <= b0) {
            return b0 - a1;
        }
        if (b1 <= a0) {
            return b1 - a0;
        }
        return 0.0;
    }

    private static double getOuterDistance(double v0, double v1, double v) {
        if (v <= v0) {
            return v0 - v;
        }
        if (v >= v1) {
            return v - v1;
        }
        return 0.0;
    }

    public static boolean assertionEnabled() {
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertsEnabled;
    }

    public static boolean isWindows() {
        return PlatformUtil.isWindows();
    }

    public static boolean isMac() {
        return PlatformUtil.isMac();
    }

    public static boolean isUnix() {
        return PlatformUtil.isUnix();
    }

    public static String convertUnicode(String src) {
        int unicodeConversionBp = -1;
        char[] buf = src.toCharArray();
        int buflen = buf.length;
        int bp = -1;
        char[] dst = new char[buflen];
        int dstIndex = 0;
        while (bp < buflen - 1) {
            char ch;
            if ((ch = buf[++bp]) == '\\' && unicodeConversionBp != bp) {
                if ((ch = buf[++bp]) == 'u') {
                    while ((ch = buf[++bp]) == 'u') {
                    }
                    int limit = bp + 3;
                    if (limit < buflen) {
                        int d;
                        char c = ch;
                        int result = Character.digit(c, 16);
                        if (result >= 0 && c > '\u007f') {
                            ch = "0123456789abcdef".charAt(result);
                        }
                        int code = d = result;
                        while (bp < limit && d >= 0) {
                            char c1;
                            int result1;
                            if ((result1 = Character.digit(c1 = (ch = buf[++bp]), 16)) >= 0 && c1 > '\u007f') {
                                ch = "0123456789abcdef".charAt(result1);
                            }
                            d = result1;
                            code = (code << 4) + d;
                        }
                        if (d >= 0) {
                            ch = (char)code;
                            unicodeConversionBp = bp;
                        }
                    }
                } else {
                    --bp;
                    ch = '\\';
                }
            }
            dst[dstIndex++] = ch;
        }
        return new String(dst, 0, dstIndex);
    }
}

