/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.restclient;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import si.nevensrok.common.restclient.HttpHandler;
import si.nevensrok.common.restclient.HttpsHandler;
import si.nevensrok.common.restclient.RestClient;
import si.nevensrok.common.ssl.CertificateHostnameVerifier;

public class RestClientUrlStreamHandler
extends URLStreamHandler {
    private HttpHandler httpHandler;
    private HttpsHandler httpsHandler;
    private RestClient restClient;

    public RestClientUrlStreamHandler(RestClient restClient) {
        HostnameVerifier hostnameVerifier;
        this.restClient = restClient;
        this.httpHandler = new HttpHandler();
        SSLSocketFactory sslSocketFactory = restClient.getSslSocketFactory();
        if (sslSocketFactory == null) {
            sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        if ((hostnameVerifier = restClient.getHostnameVerifier()) == null) {
            hostnameVerifier = new CertificateHostnameVerifier();
        }
        this.httpsHandler = new HttpsHandler(sslSocketFactory, hostnameVerifier);
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        if ("http".equalsIgnoreCase(url.getProtocol())) {
            return this.httpHandler.openConnection(url, this.restClient.getProxy());
        }
        if ("https".equalsIgnoreCase(url.getProtocol())) {
            return this.httpsHandler.openConnection(url, this.restClient.getProxy());
        }
        throw new IllegalArgumentException("Protocol '" + url.getProtocol() + "' is not supported");
    }
}

