/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.qrcode.codes;

import java.io.Serializable;
import si.nevensrok.common.qrcode.QRCode;
import si.nevensrok.common.qrcode.QRCodeException;
import si.nevensrok.common.qrcode.QRCodeType;

public class QRContactCode
implements QRCode,
Serializable {
    private static final long serialVersionUID = 5900025005862943178L;
    private String name;
    private String phone;
    private String email;
    private String address;
    private String webPage;
    private String memo;

    public QRContactCode() {
    }

    public QRContactCode(String name, String phone, String email, String address, String webPage, String memo) {
        this.name = name;
        this.phone = phone;
        this.email = email;
        this.address = address;
        this.webPage = webPage;
        this.memo = memo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getWebPage() {
        return this.webPage;
    }

    public void setWebPage(String webPage) {
        this.webPage = webPage;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @Override
    public QRCodeType getType() {
        return QRCodeType.CONTACT;
    }

    @Override
    public String getCodeText() {
        StringBuilder text = new StringBuilder();
        text.append("MECARD:");
        if (this.name != null && !this.name.isEmpty()) {
            text.append("N:");
            text.append(this.name);
            text.append(";");
        }
        if (this.phone != null && !this.phone.isEmpty()) {
            text.append("TEL:");
            text.append(this.phone);
            text.append(";");
        }
        if (this.webPage != null && !this.webPage.isEmpty()) {
            text.append("URL:");
            text.append(this.webPage);
            text.append(";");
        }
        if (this.email != null && !this.email.isEmpty()) {
            text.append("EMAIL:");
            text.append(this.email);
            text.append(";");
        }
        if (this.address != null && !this.address.isEmpty()) {
            text.append("ADR:");
            text.append(this.address);
            text.append(";");
        }
        if (this.memo != null && !this.memo.isEmpty()) {
            text.append("NOTE:");
            text.append(this.memo);
            text.append(";");
        }
        text.append(";");
        return text.toString();
    }

    @Override
    public void parseCode(String text) throws QRCodeException {
        try {
            if (!text.startsWith("MECARD:")) {
                throw new QRCodeException("Not a MECARD QR code!");
            }
            text = text.substring(7, text.length());
            for (String part : text.split(";")) {
                if (part.startsWith("N:")) {
                    this.name = part.substring(2, part.length());
                    continue;
                }
                if (part.startsWith("TEL:")) {
                    this.phone = part.substring(4, part.length());
                    continue;
                }
                if (part.startsWith("URL:")) {
                    this.webPage = part.substring(4, part.length());
                    continue;
                }
                if (part.startsWith("EMAIL:")) {
                    this.email = part.substring(6, part.length());
                    continue;
                }
                if (part.startsWith("ADR:")) {
                    this.address = part.substring(4, part.length());
                    continue;
                }
                if (!part.startsWith("NOTE:")) continue;
                this.memo = part.substring(5, part.length());
            }
        }
        catch (QRCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QRCodeException("Error while parsing QR code", e);
        }
    }

    public String toString() {
        return "QRContactCode [name=" + this.name + ", phone=" + this.phone + ", email=" + this.email + ", address=" + this.address + ", webPage=" + this.webPage + ", memo=" + this.memo + "]";
    }
}

