/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ldap;

import java.util.Hashtable;
import java.util.List;
import javax.naming.Context;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ldap.LdapAuthenticationClient;
import si.nevensrok.common.ldap.LdapClientImpl;
import si.nevensrok.common.ldap.LdapUtil;

public class LdapAuthenticationGroupClientImpl
extends LdapClientImpl
implements LdapAuthenticationClient {
    private static final Logger log = LoggerFactory.getLogger(LdapAuthenticationGroupClientImpl.class);
    private String groupSearchFilter = "objectClass=group";
    private String memberPropertyName = "member";
    private String usernameAttribute = "uid";
    private String passwordAttribute = "userpassword";
    private boolean checkPasswordViaAuth = true;

    public void setGroupSearchFilter(String groupSearchFilter) {
        this.groupSearchFilter = groupSearchFilter;
    }

    public void setMemberPropertyName(String memberPropertyName) {
        this.memberPropertyName = memberPropertyName;
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }

    public void setCheckPasswordViaAuth(boolean checkPasswordViaAuth) {
        this.checkPasswordViaAuth = checkPasswordViaAuth;
    }

    @Override
    public boolean authenticateUser(String username, String password) {
        if (username == null || username.isEmpty() || password == null || password.isEmpty()) {
            return false;
        }
        List<SearchResult> groups = this.search(this.groupSearchFilter);
        log.trace("Groups found by filter: {}", (Object)groups.size());
        for (SearchResult searchResult : groups) {
            try {
                List<Object> members = LdapUtil.getAttributeValues(searchResult, this.memberPropertyName);
                log.trace("Members count: {}", (Object)members.size());
                for (Object memberObject : members) {
                    try {
                        String memberSearch = (String)memberObject;
                        log.debug("Cheking member: {}", (Object)memberSearch);
                        List<SearchResult> memberResult = this.search(memberSearch, "objectClass=*");
                        for (SearchResult memberSearchResult : memberResult) {
                            String resultUsername = this.getAttributeAsString(memberSearchResult, this.usernameAttribute);
                            if (resultUsername == null || !resultUsername.equals(username)) continue;
                            log.trace("Find username: {}", (Object)resultUsername);
                            if (this.checkPasswordViaAuth) {
                                String dn = searchResult.getNameInNamespace();
                                log.trace("DN: {}", (Object)dn);
                                Hashtable<String, String> env = new Hashtable<String, String>();
                                env.put("java.naming.security.authentication", "simple");
                                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                                env.put("java.naming.provider.url", this.getProviderUrl());
                                env.put("java.naming.security.principal", dn);
                                env.put("java.naming.security.credentials", password);
                                Context ldapContext = null;
                                try {
                                    ldapContext = new InitialLdapContext(env, null);
                                    ldapContext.close();
                                    return true;
                                }
                                catch (Exception e) {
                                    try {
                                        ldapContext.close();
                                    }
                                    catch (Exception exception) {}
                                    continue;
                                }
                            }
                            String resultPassword = this.getAttributeAsString(searchResult, this.passwordAttribute);
                            if (resultPassword == null || !LdapUtil.checkPassword(password, resultPassword)) continue;
                            return true;
                        }
                    }
                    catch (Exception e) {
                        log.trace("Error cheking member", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                log.error("Error cheking authentication for user", (Throwable)e);
            }
        }
        return false;
    }

    private String getAttributeAsString(SearchResult searchResult, String attributeName) {
        try {
            Object value = LdapUtil.getAttributeValue(searchResult, attributeName);
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof byte[]) {
                return new String((byte[])value, "UTF-8");
            }
        }
        catch (Exception e) {
            log.error("Error fetching attribute", (Throwable)e);
        }
        return null;
    }
}

