/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.executor;

import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import si.nevensrok.common.executor.FutureWrapper;
import si.nevensrok.common.executor.TaskPriorityBlockingQueue;
import si.nevensrok.common.executor.TaskWrapper;

public class TaskExecutor<P> {
    private boolean stop = false;
    private boolean stopAfterEmptyQueue = false;
    private boolean terminated = false;
    private TaskPriorityBlockingQueue<P> queue;
    private Thread thread;

    public TaskExecutor(final TaskPriorityBlockingQueue<P> queue, ThreadFactory threadFactory) {
        this.queue = queue;
        this.thread = threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                while (!TaskExecutor.this.stop) {
                    Object taskWrapper = null;
                    if (TaskExecutor.this.stopAfterEmptyQueue) {
                        taskWrapper = (TaskWrapper)queue.poll();
                        if (taskWrapper == null) {
                            break;
                        }
                    } else {
                        try {
                            taskWrapper = queue.take();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (taskWrapper == null) continue;
                    if (taskWrapper instanceof FutureWrapper) {
                        FutureWrapper futureWrapper = (FutureWrapper)taskWrapper;
                        Object task = futureWrapper.getTask();
                        futureWrapper.setThread(TaskExecutor.this.thread);
                        if (task instanceof Runnable) {
                            try {
                                ((Runnable)task).run();
                                futureWrapper.setDone();
                            }
                            catch (Throwable e) {
                                futureWrapper.setThrowable(e);
                            }
                            continue;
                        }
                        if (!(task instanceof Callable)) continue;
                        try {
                            Object result = ((Callable)task).call();
                            futureWrapper.setResult(result);
                        }
                        catch (Throwable e) {
                            futureWrapper.setThrowable(e);
                        }
                        continue;
                    }
                    Object task = ((TaskWrapper)taskWrapper).getTask();
                    if (task instanceof Runnable) {
                        try {
                            ((Runnable)task).run();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (!(task instanceof Callable)) continue;
                    try {
                        ((Callable)task).call();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                TaskExecutor.this.terminated = true;
            }
        });
        this.thread.start();
    }

    public void shutdown() {
        if (!this.stop) {
            this.stop = true;
            this.queue.shutdown();
        }
    }

    public void shutdownAfterEmptyQueue() {
        if (!this.stop && !this.stopAfterEmptyQueue) {
            this.stopAfterEmptyQueue = true;
            this.queue.shutdown();
        }
    }

    public boolean isTerminated() {
        return this.terminated;
    }
}

