/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal;

import java.awt.Color;
import javax.swing.JPanel;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.fw.TimeTracker;
import si.nevensrok.jtekma.tabla.gui.horizontal.CategoryPanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.HosekomiPanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.TimePanel;

public class InfoPanel
extends JPanel {
    private HosekomiPanel hosekomiPanel = new HosekomiPanel();
    private TimePanel timePanel = new TimePanel();
    private CategoryPanel categoryPanel = new CategoryPanel();

    public InfoPanel() {
        this.setLayout(null);
        this.add(this.hosekomiPanel);
        this.add(this.timePanel);
        this.add(this.categoryPanel);
    }

    public void setTimeTracker(TimeTracker timeTracker) {
        this.hosekomiPanel.setTimeTracker(timeTracker);
        this.timePanel.setTimeTracker(timeTracker);
    }

    public void setMatchData(MatchData matchData) {
        this.hosekomiPanel.setMatchData(matchData);
        this.timePanel.setMatchData(matchData);
        this.categoryPanel.setMatchData(matchData);
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.categoryPanel.setTablaManager(tablaManager);
    }

    public void redrawElements() {
        int width = this.getWidth();
        int height = this.getHeight();
        int offsetBottom = (int)Math.round((double)height * 0.05);
        int hosekomiWidth = (int)Math.floor((float)width * 0.2f);
        this.hosekomiPanel.setLocation(0, 0);
        this.hosekomiPanel.setSize(hosekomiWidth, height - offsetBottom);
        int timeWidth = (int)Math.floor((float)width * 0.35f);
        this.timePanel.setLocation(hosekomiWidth, 0);
        this.timePanel.setSize(timeWidth, height - offsetBottom);
        this.categoryPanel.setLocation(hosekomiWidth + timeWidth, 0);
        this.categoryPanel.setSize(width - hosekomiWidth - timeWidth, height - offsetBottom);
        this.hosekomiPanel.redrawElements();
        this.timePanel.redrawElements();
        this.categoryPanel.redrawElements();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.hosekomiPanel != null) {
            this.hosekomiPanel.setBackground(bg);
        }
        if (this.timePanel != null) {
            this.timePanel.setBackground(bg);
        }
        if (this.categoryPanel != null) {
            this.categoryPanel.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.hosekomiPanel != null) {
            this.hosekomiPanel.setForeground(fg);
        }
        if (this.timePanel != null) {
            this.timePanel.setForeground(fg);
        }
        if (this.categoryPanel != null) {
            this.categoryPanel.setForeground(fg);
        }
    }
}

