/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.security.KeyStore;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import si.nevensrok.common.ssl.CustomSslContextGenerator;
import si.nevensrok.common.ssl.KeystoreKeyManager;
import si.nevensrok.common.ssl.KeystoreTrustManager;

public class KeystoreSslContextGenerator
extends CustomSslContextGenerator {
    private KeyStore keyStore;
    private String keyStorePassword;
    private KeyStore trustStore;

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    @Override
    protected X509KeyManager generateKeyManager() {
        if (this.keyStore != null && this.keyStorePassword != null) {
            return new KeystoreKeyManager(this.keyStore, this.keyStorePassword);
        }
        return null;
    }

    @Override
    protected X509TrustManager generateTrustManager() {
        if (this.trustStore != null) {
            return new KeystoreTrustManager(this.trustStore);
        }
        return null;
    }
}

