/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.smssender;

import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.smssender.SmsMessage;
import si.nevensrok.common.smssender.SmsMessageResponse;
import si.nevensrok.common.smssender.SmsSender;
import si.nevensrok.common.threads.ThreadUtil;

public abstract class BackgroundSmsSender
implements SmsSender,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(BackgroundSmsSender.class);
    private boolean active = true;
    private LinkedList<SmsMessage> smsList = new LinkedList();

    public void afterPropertiesSet() throws Exception {
        ThreadUtil.runInBackground(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                log.info("Starting background sms message sender thread");
                while (BackgroundSmsSender.this.active) {
                    SmsMessage smsMessage = null;
                    LinkedList linkedList = BackgroundSmsSender.this.smsList;
                    synchronized (linkedList) {
                        while (BackgroundSmsSender.this.smsList.isEmpty() && BackgroundSmsSender.this.active) {
                            try {
                                BackgroundSmsSender.this.smsList.wait();
                            }
                            catch (Exception exception) {}
                        }
                        if (!BackgroundSmsSender.this.smsList.isEmpty()) {
                            smsMessage = (SmsMessage)BackgroundSmsSender.this.smsList.removeFirst();
                        }
                    }
                    if (smsMessage == null) continue;
                    try {
                        log.trace("Sending sms message: {}", (Object)smsMessage);
                        SmsMessageResponse smsMessageResponse = BackgroundSmsSender.this.sendSmsMessage(smsMessage);
                        log.trace("Send sms message response: {}", (Object)smsMessageResponse);
                    }
                    catch (Exception e) {
                        log.error("Error while sending sms message", (Throwable)e);
                    }
                }
                log.info("Stopping background sms message sender thread");
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        this.active = false;
        LinkedList<SmsMessage> linkedList = this.smsList;
        synchronized (linkedList) {
            this.smsList.clear();
            this.smsList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendSmsMessageInBackground(SmsMessage smsMessage) {
        if (this.active) {
            LinkedList<SmsMessage> linkedList = this.smsList;
            synchronized (linkedList) {
                this.smsList.add(smsMessage);
                this.smsList.notifyAll();
            }
        }
    }
}

