/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.freemarker;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.springframework.core.io.ClassPathResource;
import si.nevensrok.common.freemarker.InputStreamTemplateSource;
import si.nevensrok.common.freemarker.TemplateSource;

public class ClasspathTemplateLoader
implements TemplateLoader {
    private String encoding = "UTF8";
    private String resourcePath = "/";
    private boolean tryGlobal = true;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        if (!this.resourcePath.endsWith("/")) {
            this.resourcePath = this.resourcePath + "/";
        }
    }

    public boolean isTryGlobal() {
        return this.tryGlobal;
    }

    public void setTryGlobal(boolean tryGlobal) {
        this.tryGlobal = tryGlobal;
    }

    public TemplateSource findTemplateSource(String name) throws IOException {
        try {
            InputStream inputStream = new ClassPathResource(this.getResourcePath() + name).getInputStream();
            return new InputStreamTemplateSource(inputStream, this.getEncoding());
        }
        catch (IOException inputStream) {
            if (this.tryGlobal) {
                try {
                    String globalPath = name;
                    if (!globalPath.startsWith("/")) {
                        globalPath = "/" + globalPath;
                    }
                    InputStream inputStream2 = new ClassPathResource(globalPath).getInputStream();
                    return new InputStreamTemplateSource(inputStream2, this.getEncoding());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public long getLastModified(Object templateSource) {
        if (templateSource instanceof TemplateSource) {
            return ((TemplateSource)templateSource).getLastModified();
        }
        return 0L;
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        if (templateSource instanceof TemplateSource) {
            return ((TemplateSource)templateSource).getReader();
        }
        throw new IOException("Invalid template source type");
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        if (templateSource instanceof TemplateSource) {
            ((TemplateSource)templateSource).close();
        }
    }
}

