/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Ellipse2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.prism.NGEllipse;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGShape;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public class Ellipse
extends Shape {
    private final Ellipse2D shape = new Ellipse2D();
    private static final int NON_RECTILINEAR_TYPE_MASK = -80;
    private DoubleProperty centerX;
    private DoubleProperty centerY;
    private final DoubleProperty radiusX = new DoublePropertyBase(){

        @Override
        public void invalidated() {
            Ellipse.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
            Ellipse.this.impl_geomChanged();
        }

        @Override
        public Object getBean() {
            return Ellipse.this;
        }

        @Override
        public String getName() {
            return "radiusX";
        }
    };
    private final DoubleProperty radiusY = new DoublePropertyBase(){

        @Override
        public void invalidated() {
            Ellipse.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
            Ellipse.this.impl_geomChanged();
        }

        @Override
        public Object getBean() {
            return Ellipse.this;
        }

        @Override
        public String getName() {
            return "radiusY";
        }
    };

    public Ellipse() {
    }

    public Ellipse(double radiusX, double radiusY) {
        this.setRadiusX(radiusX);
        this.setRadiusY(radiusY);
    }

    public Ellipse(double centerX, double centerY, double radiusX, double radiusY) {
        this(radiusX, radiusY);
        this.setCenterX(centerX);
        this.setCenterY(centerY);
    }

    public final void setCenterX(double value) {
        if (this.centerX != null || value != 0.0) {
            this.centerXProperty().set(value);
        }
    }

    public final double getCenterX() {
        return this.centerX == null ? 0.0 : this.centerX.get();
    }

    public final DoubleProperty centerXProperty() {
        if (this.centerX == null) {
            this.centerX = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Ellipse.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Ellipse.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Ellipse.this;
                }

                @Override
                public String getName() {
                    return "centerX";
                }
            };
        }
        return this.centerX;
    }

    public final void setCenterY(double value) {
        if (this.centerY != null || value != 0.0) {
            this.centerYProperty().set(value);
        }
    }

    public final double getCenterY() {
        return this.centerY == null ? 0.0 : this.centerY.get();
    }

    public final DoubleProperty centerYProperty() {
        if (this.centerY == null) {
            this.centerY = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Ellipse.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    Ellipse.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return Ellipse.this;
                }

                @Override
                public String getName() {
                    return "centerY";
                }
            };
        }
        return this.centerY;
    }

    public final void setRadiusX(double value) {
        this.radiusX.set(value);
    }

    public final double getRadiusX() {
        return this.radiusX.get();
    }

    public final DoubleProperty radiusXProperty() {
        return this.radiusX;
    }

    public final void setRadiusY(double value) {
        this.radiusY.set(value);
    }

    public final double getRadiusY() {
        return this.radiusY.get();
    }

    public final DoubleProperty radiusYProperty() {
        return this.radiusY;
    }

    @Override
    @Deprecated
    protected NGNode impl_createPeer() {
        return new NGEllipse();
    }

    @Override
    StrokeLineJoin convertLineJoin(StrokeLineJoin t) {
        return StrokeLineJoin.BEVEL;
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        double upad;
        double dpad;
        if (this.impl_mode == NGShape.Mode.EMPTY) {
            return bounds.makeEmpty();
        }
        if ((tx.getType() & 0xFFFFFFB0) != 0) {
            return this.computeShapeBounds(bounds, tx, this.impl_configShape());
        }
        double x = this.getCenterX() - this.getRadiusX();
        double y = this.getCenterY() - this.getRadiusY();
        double width = 2.0 * this.getRadiusX();
        double height = 2.0 * this.getRadiusY();
        if (this.impl_mode == NGShape.Mode.FILL || this.getStrokeType() == StrokeType.INSIDE) {
            dpad = 0.0;
            upad = 0.0;
        } else {
            upad = this.getStrokeWidth();
            if (this.getStrokeType() == StrokeType.CENTERED) {
                upad /= 2.0;
            }
            dpad = 0.0;
        }
        return this.computeBounds(bounds, tx, upad, dpad, x, y, width, height);
    }

    @Override
    @Deprecated
    public Ellipse2D impl_configShape() {
        this.shape.setFrame((float)(this.getCenterX() - this.getRadiusX()), (float)(this.getCenterY() - this.getRadiusY()), (float)(this.getRadiusX() * 2.0), (float)(this.getRadiusY() * 2.0));
        return this.shape;
    }

    @Override
    @Deprecated
    public void impl_updatePeer() {
        super.impl_updatePeer();
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            NGEllipse peer = (NGEllipse)this.impl_getPeer();
            peer.updateEllipse((float)this.getCenterX(), (float)this.getCenterY(), (float)this.getRadiusX(), (float)this.getRadiusY());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Ellipse[");
        String id = this.getId();
        if (id != null) {
            sb.append("id=").append(id).append(", ");
        }
        sb.append("centerX=").append(this.getCenterX());
        sb.append(", centerY=").append(this.getCenterY());
        sb.append(", radiusX=").append(this.getRadiusX());
        sb.append(", radiusY=").append(this.getRadiusY());
        sb.append(", fill=").append(this.getFill());
        Paint stroke = this.getStroke();
        if (stroke != null) {
            sb.append(", stroke=").append(stroke);
            sb.append(", strokeWidth=").append(this.getStrokeWidth());
        }
        return sb.append("]").toString();
    }
}

