/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.uuid;

import java.util.UUID;

public class UUIDUtil {
    public static UUID generateFromBytes(byte[] uuidBytes) {
        int i;
        if (uuidBytes == null) {
            throw new IllegalArgumentException("Byte array is null");
        }
        if (uuidBytes.length != 16) {
            throw new IllegalArgumentException("Byte length is not 16");
        }
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(uuidBytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(uuidBytes[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }
}

