-- no limit cycle sequence
CREATE SEQUENCE RequestIdSeq INCREMENT 1 MINVALUE 1 START 1 CACHE 10;

-- limit and cycle sequence
CREATE SEQUENCE RequestIdSeq2 INCREMENT 1 MINVALUE 1 MAXVALUE 9999999999 START 1 CACHE 10 CYCLE;

-- create table
CREATE TABLE Requests
(
	RequestId bigint NOT NULL,
	MethodId varchar(4096) NOT NULL,
	BeanName varchar(4096),
	RequestDate timestamp with time zone NOT NULL,
	ThreadName varchar(4096) NOT NULL,
	Duration int NOT NULL,
	WithoutError boolean NOT NULL,
	ErrorData text,
	MachineIp4 varchar(15),
	MachineIp6 varchar(45),
	MachineHostname varchar(1024),
	MachineName varchar(100),
	ProcessName varchar(1024),
	PRIMARY KEY (RequestId)
) WITHOUT OIDS;


CREATE TABLE RequestDatas
(
	RequestId bigint NOT NULL,
	ParameterName varchar(4096) NOT NULL,
	ParameterValue text,
	ParameterClass varchar(4096)
) WITHOUT OIDS;


CREATE TABLE ResponseDatas
(
	RequestId bigint NOT NULL,
	ParameterName varchar(4096) NOT NULL,
	ParameterValue text,
	ParameterClass varchar(4096)
) WITHOUT OIDS;


ALTER TABLE ResponseDatas
	ADD FOREIGN KEY (RequestId)
	REFERENCES Requests (RequestId)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE RequestDatas
	ADD FOREIGN KEY (RequestId)
	REFERENCES Requests (RequestId)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


CREATE INDEX ResponseDatas_RequestId_fkey ON ResponseDatas USING BTREE (RequestId);
CREATE INDEX RequestDatas_RequestId_fkey ON RequestDatas USING BTREE (RequestId);


CREATE INDEX SearchIndex1 ON Requests USING BTREE (RequestDate,MethodId,BeanName,WithoutError);

