/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.state;

import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.impl.state.GaussianRenderState;
import com.sun.scenario.effect.impl.state.GaussianShadowState;
import com.sun.scenario.effect.impl.state.HVSeparableKernel;
import com.sun.scenario.effect.impl.state.LinearConvolveRenderState;

public class GaussianBlurState
extends HVSeparableKernel {
    private float hradius;
    private float vradius;

    void checkRadius(float radius) {
        if (radius < 0.0f || radius > 63.0f) {
            throw new IllegalArgumentException("Radius must be in the range [1,63]");
        }
    }

    public float getRadius() {
        return (this.hradius + this.vradius) / 2.0f;
    }

    public void setRadius(float radius) {
        this.checkRadius(radius);
        this.hradius = radius;
        this.vradius = radius;
    }

    public float getHRadius() {
        return this.hradius;
    }

    public void setHRadius(float hradius) {
        this.checkRadius(hradius);
        this.hradius = hradius;
    }

    public float getVRadius() {
        return this.vradius;
    }

    public void setVRadius(float vradius) {
        this.checkRadius(vradius);
        this.vradius = vradius;
    }

    float getRadius(int pass) {
        return pass == 0 ? this.hradius : this.vradius;
    }

    @Override
    public boolean isNop() {
        return this.hradius == 0.0f && this.vradius == 0.0f;
    }

    public int getPad(int pass) {
        return (int)Math.ceil(this.getRadius(pass));
    }

    @Override
    public int getKernelSize(int pass) {
        return this.getPad(pass) * 2 + 1;
    }

    public float getSpread() {
        return 0.0f;
    }

    public Color4f getShadowColor() {
        return null;
    }

    @Override
    public LinearConvolveRenderState getRenderState(BaseTransform filtertx) {
        return new GaussianRenderState(this.hradius, this.vradius, this.getSpread(), this instanceof GaussianShadowState, this.getShadowColor(), filtertx);
    }
}

