/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.collections.SetListenerHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javafx.beans.InvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;

abstract class BitSet<T>
implements ObservableSet<T> {
    private static final long[] EMPTY_SET = new long[0];
    private long[] bits = EMPTY_SET;
    private SetListenerHelper<T> listenerHelper;

    protected BitSet() {
    }

    @Override
    public int size() {
        int size = 0;
        if (this.bits.length > 0) {
            for (int n = 0; n < this.bits.length; ++n) {
                long mask = this.bits[n];
                if (mask == 0L) continue;
                size += Long.bitCount(mask);
            }
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        if (this.bits.length > 0) {
            for (int n = 0; n < this.bits.length; ++n) {
                long mask = this.bits[n];
                if (mask == 0L) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int next = -1;
            int element = 0;
            int index = -1;

            @Override
            public boolean hasNext() {
                long bit;
                if (BitSet.this.bits == null || BitSet.this.bits.length == 0) {
                    return false;
                }
                boolean found = false;
                do {
                    if (++this.next < 64) continue;
                    if (++this.element < BitSet.this.bits.length) {
                        this.next = 0;
                        continue;
                    }
                    return false;
                } while (!(found = ((bit = 1L << this.next) & BitSet.this.bits[this.element]) == bit));
                if (found) {
                    this.index = 64 * this.element + this.next;
                }
                return found;
            }

            @Override
            public T next() {
                try {
                    return BitSet.this.getT(this.index);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException("[" + this.element + "][" + this.next + "]");
                }
            }

            @Override
            public void remove() {
                try {
                    Object t = BitSet.this.getT(this.index);
                    BitSet.this.remove(t);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException("[" + this.element + "][" + this.next + "]");
                }
            }
        };
    }

    @Override
    public boolean add(T t) {
        boolean modified;
        if (t == null) {
            return false;
        }
        int element = this.getIndex(t) / 64;
        long bit = 1L << this.getIndex(t) % 64;
        if (element >= this.bits.length) {
            long[] temp = new long[element + 1];
            System.arraycopy(this.bits, 0, temp, 0, this.bits.length);
            this.bits = temp;
        }
        long temp = this.bits[element];
        this.bits[element] = temp | bit;
        boolean bl = modified = this.bits[element] != temp;
        if (modified && SetListenerHelper.hasListeners(this.listenerHelper)) {
            this.notifyObservers(t, false);
        }
        return modified;
    }

    @Override
    public boolean remove(Object o) {
        boolean modified;
        if (o == null) {
            return false;
        }
        T t = this.cast(o);
        int element = this.getIndex(t) / 64;
        long bit = 1L << this.getIndex(t) % 64;
        if (element >= this.bits.length) {
            return false;
        }
        long temp = this.bits[element];
        this.bits[element] = temp & (bit ^ 0xFFFFFFFFFFFFFFFFL);
        boolean bl = modified = this.bits[element] != temp;
        if (modified) {
            if (SetListenerHelper.hasListeners(this.listenerHelper)) {
                this.notifyObservers(t, true);
            }
            boolean isEmpty = true;
            for (int n = 0; n < this.bits.length && isEmpty; isEmpty &= this.bits[n] == 0L, ++n) {
            }
            if (isEmpty) {
                this.bits = EMPTY_SET;
            }
        }
        return modified;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        T t = this.cast(o);
        int element = this.getIndex(t) / 64;
        long bit = 1L << this.getIndex(t) % 64;
        return element < this.bits.length && (this.bits[element] & bit) == bit;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null || this.getClass() != c.getClass()) {
            return false;
        }
        BitSet other = (BitSet)c;
        if (this.bits.length == 0 && other.bits.length == 0) {
            return true;
        }
        if (this.bits.length < other.bits.length) {
            return false;
        }
        int max = other.bits.length;
        for (int n = 0; n < max; ++n) {
            if ((this.bits[n] & other.bits[n]) == other.bits[n]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int n;
        if (c == null || this.getClass() != c.getClass()) {
            return false;
        }
        boolean modified = false;
        BitSet other = (BitSet)c;
        long[] maskOne = this.bits;
        int a = maskOne.length;
        long[] maskTwo = other.bits;
        int b = maskTwo.length;
        int max = a < b ? b : a;
        long[] union = max > 0 ? new long[max] : EMPTY_SET;
        for (n = 0; n < max; ++n) {
            if (n < maskOne.length && n < maskTwo.length) {
                union[n] = maskOne[n] | maskTwo[n];
                modified |= union[n] != maskOne[n];
                continue;
            }
            if (n < maskOne.length) {
                union[n] = maskOne[n];
                modified |= false;
                continue;
            }
            union[n] = maskTwo[n];
            modified = true;
        }
        if (modified) {
            if (SetListenerHelper.hasListeners(this.listenerHelper)) {
                for (n = 0; n < max; ++n) {
                    long bitsAdded = 0L;
                    if (n < maskOne.length && n < maskTwo.length) {
                        bitsAdded = (maskOne[n] ^ 0xFFFFFFFFFFFFFFFFL) & maskTwo[n];
                    } else {
                        if (n < maskOne.length) continue;
                        bitsAdded = maskTwo[n];
                    }
                    for (int bit = 0; bit < 64; ++bit) {
                        long m = 1L << bit;
                        if ((m & bitsAdded) != m) continue;
                        T t = this.getT(n * 64 + bit);
                        this.notifyObservers(t, false);
                    }
                }
            }
            this.bits = union;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int n;
        if (c == null || this.getClass() != c.getClass()) {
            this.clear();
            return true;
        }
        boolean modified = false;
        BitSet other = (BitSet)c;
        long[] maskOne = this.bits;
        int a = maskOne.length;
        long[] maskTwo = other.bits;
        int b = maskTwo.length;
        int max = a < b ? a : b;
        long[] intersection = max > 0 ? new long[max] : EMPTY_SET;
        modified |= maskOne.length > max;
        boolean isEmpty = true;
        for (n = 0; n < max; ++n) {
            intersection[n] = maskOne[n] & maskTwo[n];
            modified |= intersection[n] != maskOne[n];
            isEmpty &= intersection[n] == 0L;
        }
        if (modified) {
            if (SetListenerHelper.hasListeners(this.listenerHelper)) {
                for (n = 0; n < maskOne.length; ++n) {
                    long bitsRemoved = 0L;
                    bitsRemoved = n < maskTwo.length ? maskOne[n] & (maskTwo[n] ^ 0xFFFFFFFFFFFFFFFFL) : maskOne[n];
                    for (int bit = 0; bit < 64; ++bit) {
                        long m = 1L << bit;
                        if ((m & bitsRemoved) != m) continue;
                        T t = this.getT(n * 64 + bit);
                        this.notifyObservers(t, true);
                    }
                }
            }
            this.bits = !isEmpty ? intersection : EMPTY_SET;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int n;
        if (c == null || this.getClass() != c.getClass()) {
            return false;
        }
        boolean modified = false;
        BitSet other = (BitSet)c;
        long[] maskOne = this.bits;
        int a = maskOne.length;
        long[] maskTwo = other.bits;
        int b = maskTwo.length;
        int max = a < b ? a : b;
        long[] difference = max > 0 ? new long[max] : EMPTY_SET;
        boolean isEmpty = true;
        for (n = 0; n < max; ++n) {
            difference[n] = maskOne[n] & (maskTwo[n] ^ 0xFFFFFFFFFFFFFFFFL);
            modified |= difference[n] != maskOne[n];
            isEmpty &= difference[n] == 0L;
        }
        if (modified) {
            if (SetListenerHelper.hasListeners(this.listenerHelper)) {
                for (n = 0; n < max; ++n) {
                    long bitsRemoved = maskOne[n] & maskTwo[n];
                    for (int bit = 0; bit < 64; ++bit) {
                        long m = 1L << bit;
                        if ((m & bitsRemoved) != m) continue;
                        T t = this.getT(n * 64 + bit);
                        this.notifyObservers(t, true);
                    }
                }
            }
            this.bits = !isEmpty ? difference : EMPTY_SET;
        }
        return modified;
    }

    @Override
    public void clear() {
        for (int n = 0; n < this.bits.length; ++n) {
            long bitsRemoved = this.bits[n];
            for (int b = 0; b < 64; ++b) {
                long m = 1L << b;
                if ((m & bitsRemoved) != m) continue;
                T t = this.getT(n * 64 + b);
                this.notifyObservers(t, true);
            }
        }
        this.bits = EMPTY_SET;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        if (this.bits.length > 0) {
            for (int n = 0; n < this.bits.length; ++n) {
                long mask = this.bits[n];
                hash = 71 * hash + (int)(mask ^ mask >>> 32);
            }
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        int b;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BitSet other = (BitSet)obj;
        int a = this.bits != null ? this.bits.length : 0;
        int n = b = other.bits != null ? other.bits.length : 0;
        if (a != b) {
            return false;
        }
        for (int m = 0; m < a; ++m) {
            long m0 = this.bits[m];
            long m1 = other.bits[m];
            if (m0 == m1) continue;
            return false;
        }
        return true;
    }

    protected abstract T getT(int var1);

    protected abstract int getIndex(T var1);

    protected abstract T cast(Object var1);

    protected long[] getBits() {
        return this.bits;
    }

    @Override
    public void addListener(SetChangeListener<? super T> setChangeListener) {
        if (setChangeListener != null) {
            this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, setChangeListener);
        }
    }

    @Override
    public void removeListener(SetChangeListener<? super T> setChangeListener) {
        if (setChangeListener != null) {
            SetListenerHelper.removeListener(this.listenerHelper, setChangeListener);
        }
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        if (invalidationListener != null) {
            this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, invalidationListener);
        }
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        if (invalidationListener != null) {
            SetListenerHelper.removeListener(this.listenerHelper, invalidationListener);
        }
    }

    private void notifyObservers(T element, boolean removed) {
        if (element != null && SetListenerHelper.hasListeners(this.listenerHelper)) {
            Change change = new Change(element, removed);
            SetListenerHelper.fireValueChangedEvent(this.listenerHelper, change);
        }
    }

    private class Change
    extends SetChangeListener.Change<T> {
        private static final boolean ELEMENT_ADDED = false;
        private static final boolean ELEMENT_REMOVED = true;
        private final T element;
        private final boolean removed;

        public Change(T element, boolean removed) {
            super(FXCollections.unmodifiableObservableSet(BitSet.this));
            this.element = element;
            this.removed = removed;
        }

        @Override
        public boolean wasAdded() {
            return !this.removed;
        }

        @Override
        public boolean wasRemoved() {
            return this.removed;
        }

        @Override
        public T getElementAdded() {
            return this.removed ? null : (Object)this.element;
        }

        @Override
        public T getElementRemoved() {
            return this.removed ? (Object)this.element : null;
        }
    }
}

