/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.TableType;
import si.nevensrok.jtekma.tabla.gui.MatchPanel;

public class TablaPanel
extends JPanel
implements MatchPanel {
    private MatchData matchData;
    private MatchPanel verticalPanel;
    private MatchPanel horizontalPanel;
    private boolean horizontalStyle = true;
    private boolean isCurrentHorizontal = false;

    public TablaPanel() {
        this.setLayout(new BorderLayout());
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public boolean isHorizontalStyle() {
        return this.horizontalStyle;
    }

    public void setHorizontalStyle(boolean horizontalStyle) {
        this.horizontalStyle = horizontalStyle;
    }

    public void setVerticalPanel(MatchPanel verticalPanel) {
        this.verticalPanel = verticalPanel;
    }

    public void setHorizontalPanel(MatchPanel horizontalPanel) {
        this.horizontalPanel = horizontalPanel;
    }

    @Override
    public void redrawElements() {
        boolean hs = this.horizontalStyle;
        if (this.matchData.getTableType() == TableType.DUO2023 || this.matchData.getTableType() == TableType.DUO_PRESENTATION) {
            hs = true;
        }
        if (hs && !this.isCurrentHorizontal) {
            this.remove((JPanel)((Object)this.verticalPanel));
            this.add((JPanel)((Object)this.horizontalPanel));
        } else if (!hs && this.isCurrentHorizontal) {
            this.remove((JPanel)((Object)this.horizontalPanel));
            this.add((JPanel)((Object)this.verticalPanel));
        }
        this.isCurrentHorizontal = hs;
        this.horizontalPanel.redrawElements();
        this.verticalPanel.redrawElements();
    }

    @Override
    public void setPoints1(float points) {
        this.verticalPanel.setPoints1(points);
        this.horizontalPanel.setPoints1(points);
    }

    @Override
    public void setPoints2(float points) {
        this.verticalPanel.setPoints2(points);
        this.horizontalPanel.setPoints2(points);
    }

    @Override
    public void setWinner1() {
        this.verticalPanel.setWinner1();
        this.horizontalPanel.setWinner1();
    }

    @Override
    public void setWinner2() {
        this.verticalPanel.setWinner2();
        this.horizontalPanel.setWinner2();
    }

    @Override
    public void resetDuoPoints() {
        this.verticalPanel.resetDuoPoints();
        this.horizontalPanel.resetDuoPoints();
    }

    @Override
    public void recalculateDuoPoints() {
        this.verticalPanel.recalculateDuoPoints();
        this.horizontalPanel.recalculateDuoPoints();
    }

    @Override
    public void selectFirstDuoField() {
        if (this.horizontalStyle) {
            this.horizontalPanel.selectFirstDuoField();
        } else {
            this.verticalPanel.selectFirstDuoField();
        }
    }
}

