/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui;

import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class InfoWindow
extends JFrame {
    private boolean operationCanceled = false;
    private int currentAttempt = 1;
    private int attemptCount = 1;
    private JLabel messageLabel = new JLabel();
    private JLabel attemptLabel = new JLabel();

    public InfoWindow() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                InfoWindow.this.operationCanceled = true;
                InfoWindow.this.setVisible(false);
            }
        });
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                InfoWindow.this.setSize(400, 200);
                InfoWindow.this.setLayout(new GridLayout(2, 1));
                InfoWindow.this.add(InfoWindow.this.messageLabel);
                InfoWindow.this.add(InfoWindow.this.attemptLabel);
                InfoWindow.this.messageLabel.setHorizontalAlignment(0);
                InfoWindow.this.attemptLabel.setHorizontalAlignment(0);
            }
        });
    }

    public void setCurrentAttempt(final int currentAttempt) {
        this.currentAttempt = currentAttempt;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                InfoWindow.this.attemptLabel.setText(String.valueOf(currentAttempt) + " / " + String.valueOf(InfoWindow.this.attemptCount));
            }
        });
    }

    public void setAttemptCount(final int attemptCount) {
        this.attemptCount = attemptCount;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                InfoWindow.this.attemptLabel.setText(String.valueOf(InfoWindow.this.currentAttempt) + " / " + String.valueOf(attemptCount));
            }
        });
    }

    public boolean isOperationCanceled() {
        return this.operationCanceled;
    }

    public void setMessage(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                InfoWindow.this.messageLabel.setText(message);
            }
        });
    }
}

