/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl.key;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class ResourcePrivateKeyLoader
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private String factoryName = "RSA";

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public PrivateKey getPrivateKey(String location) {
        try {
            Resource resource = this.applicationContext.getResource(location);
            KeyFactory keyFactory = KeyFactory.getInstance(this.factoryName);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
            InputStream rootKeyInputStream = resource.getInputStream();
            int n = rootKeyInputStream.read();
            while (n >= 0) {
                buffer.write(n);
                n = rootKeyInputStream.read();
            }
            PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(buffer.toByteArray());
            PrivateKey privateKey = keyFactory.generatePrivate(encodedKeySpec);
            return privateKey;
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading private key from resource " + location, e);
        }
    }
}

