/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.x509.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ssl.BcRevokedCertificateChecker;
import si.nevensrok.common.ssl.RevokedCertificate;
import si.nevensrok.common.ssl.RevokedCertificateChecker;
import si.nevensrok.common.utils.ByteUtil;
import si.nevensrok.common.utils.HashUtil;

public class SystemRevokedCertificateChecker
implements RevokedCertificateChecker,
BcRevokedCertificateChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemRevokedCertificateChecker.class);
    private static SystemRevokedCertificateChecker systemRevokedCertificateChecker;
    private List<RevokedCertificate> revokedCertificates;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadBlacklist(List<RevokedCertificate> revokedCertificates) {
        InputStream inputStream = null;
        BufferedReader reader = null;
        try {
            File file = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "blacklist");
            inputStream = new FileInputStream(file);
            reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = reader.readLine();
            while (line != null) {
                String base64;
                if (line.startsWith("SHA1-Digest-Manifest:")) {
                    base64 = line.substring(21).trim();
                    byte[] sha1 = ByteUtil.fromBase64String((String)base64);
                    revokedCertificates.add(new RevokedCertificate(null, sha1, null));
                } else if (line.startsWith("SHA-256-Digest-Manifest:")) {
                    base64 = line.substring(24).trim();
                    byte[] sha256 = ByteUtil.fromBase64String((String)base64);
                    revokedCertificates.add(new RevokedCertificate(null, null, sha256));
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error loading system blacklist", (Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadBlacklistedCerts(List<RevokedCertificate> revokedCertificates) {
        InputStream inputStream = null;
        BufferedReader reader = null;
        try {
            File file = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "blacklisted.certs");
            inputStream = new FileInputStream(file);
            reader = new BufferedReader(new InputStreamReader(inputStream));
            String algorithm = "SHA-256";
            String line = reader.readLine();
            while (line != null) {
                if (!line.trim().isEmpty()) {
                    if (line.trim().equalsIgnoreCase("Algorithm=SHA-256")) {
                        algorithm = "SHA-256";
                    } else if (line.trim().equalsIgnoreCase("Algorithm=SHA1")) {
                        algorithm = "SHA1";
                    } else if ("SHA-256".equals(algorithm)) {
                        byte[] sha256 = ByteUtil.fromHexString((String)line.trim());
                        revokedCertificates.add(new RevokedCertificate(null, null, sha256));
                    } else if ("SHA1".equals(algorithm)) {
                        byte[] sha1 = ByteUtil.fromHexString((String)line.trim());
                        revokedCertificates.add(new RevokedCertificate(null, sha1, null));
                    }
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error loading system blacklisted certs", (Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static SystemRevokedCertificateChecker getSystemRevokedCertificateChecker() {
        return systemRevokedCertificateChecker;
    }

    private SystemRevokedCertificateChecker(List<RevokedCertificate> revokedCertificates) {
        this.revokedCertificates = revokedCertificates;
    }

    @Override
    public boolean isCertificateRevoked(java.security.cert.Certificate certificate) {
        if (this.revokedCertificates == null) {
            return false;
        }
        try {
            byte[] sha1sum = null;
            byte[] sha256sum = null;
            for (RevokedCertificate revokedCertificate : this.revokedCertificates) {
                boolean isRevoked = false;
                if (revokedCertificate.getSerialNumber() != null) {
                    X509Certificate cert = (X509Certificate)certificate;
                    if (!revokedCertificate.getSerialNumber().equals(cert.getSerialNumber())) continue;
                    isRevoked = true;
                }
                if (revokedCertificate.getSha1sum() != null) {
                    if (sha1sum == null) {
                        sha1sum = HashUtil.generateHash((byte[])certificate.getEncoded(), (HashUtil.HashType)HashUtil.HashType.SHA1);
                    }
                    if (!Arrays.equals(sha1sum, revokedCertificate.getSha1sum())) continue;
                    isRevoked = true;
                }
                if (revokedCertificate.getSha256sum() != null) {
                    if (sha256sum == null) {
                        sha256sum = HashUtil.generateHash((byte[])certificate.getEncoded(), (HashUtil.HashType)HashUtil.HashType.SHA256);
                    }
                    if (!Arrays.equals(sha256sum, revokedCertificate.getSha256sum())) continue;
                    isRevoked = true;
                }
                if (!isRevoked) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error checking if certificate is revoked", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean isCertificateRevoked(Certificate certificate) {
        if (this.revokedCertificates == null) {
            return false;
        }
        try {
            byte[] sha1sum = null;
            byte[] sha256sum = null;
            for (RevokedCertificate revokedCertificate : this.revokedCertificates) {
                boolean isRevoked = false;
                if (revokedCertificate.getSerialNumber() != null) {
                    if (!revokedCertificate.getSerialNumber().equals(certificate.getSerialNumber().getValue())) continue;
                    isRevoked = true;
                }
                if (revokedCertificate.getSha1sum() != null) {
                    if (sha1sum == null) {
                        sha1sum = HashUtil.generateHash((byte[])certificate.getEncoded(), (HashUtil.HashType)HashUtil.HashType.SHA1);
                    }
                    if (!Arrays.equals(sha1sum, revokedCertificate.getSha1sum())) continue;
                    isRevoked = true;
                }
                if (revokedCertificate.getSha256sum() != null) {
                    if (sha256sum == null) {
                        sha256sum = HashUtil.generateHash((byte[])certificate.getEncoded(), (HashUtil.HashType)HashUtil.HashType.SHA256);
                    }
                    if (!Arrays.equals(sha256sum, revokedCertificate.getSha256sum())) continue;
                    isRevoked = true;
                }
                if (!isRevoked) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error checking if certificate is revoked", (Throwable)e);
        }
        return false;
    }

    static {
        LinkedList<RevokedCertificate> revokedCertificates = new LinkedList<RevokedCertificate>();
        SystemRevokedCertificateChecker.loadBlacklist(revokedCertificates);
        SystemRevokedCertificateChecker.loadBlacklistedCerts(revokedCertificates);
        systemRevokedCertificateChecker = new SystemRevokedCertificateChecker(revokedCertificates);
    }
}

