/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.restclient;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import si.nevensrok.common.utils.StringUtil;

public final class RestClientUtil {
    public static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";

    private RestClientUtil() {
    }

    public static String formatCalendar(Calendar calendar) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        dateFormat.setTimeZone(calendar.getTimeZone());
        return dateFormat.format(calendar.getTime());
    }

    public static Calendar parseCalendar(String value) {
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        Date date = RestClientUtil.parseDate(value);
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }
        return null;
    }

    public static String formatDate(Date calendar) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        return dateFormat.format(calendar.getTime());
    }

    public static Date parseDate(String value) {
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.US);
            return dateFormat.parse(value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String extractMimeType(String contentType) {
        if (StringUtil.isEmpty((String)contentType)) {
            return null;
        }
        int index = contentType.indexOf(59);
        if (index < 0) {
            return contentType;
        }
        return contentType.substring(0, index);
    }

    public static String extractCharset(String contentType) {
        String[] parts;
        if (StringUtil.isEmpty((String)contentType)) {
            return null;
        }
        for (String part : parts = contentType.split(";")) {
            if (!(part = part.trim()).toLowerCase().startsWith("charset=")) continue;
            return part.substring(8);
        }
        return null;
    }
}

